package com.xforceplus.janus.framework.record.cmd;

import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.bridgehead.core.monitor.JanusUploader;
import com.xforceplus.janus.framework.cmd.IJanusCmdHandler;
import com.xforceplus.janus.framework.dto.RecordPageParam;
import com.xforceplus.janus.framework.dto.Result;
import com.xforceplus.janus.framework.record.portal.AccessRecordService;
import com.xforceplus.janus.framework.util.PageUtils;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Author: xuchuanhou
 * @Date:2022/4/8上午10:19
 */
@Component
public class QueryPageListCmdHandler implements IJanusCmdHandler {

    @Autowired
    JanusUploader janusUploader;

    @Autowired
    private AccessRecordService accessRecordService;

    @Override
    public void doHandler(SealedMessage sealedMessage) {
        RecordPageParam param = JacksonUtil.getInstance().fromJson(sealedMessage.getPayload().getObj().toString(), RecordPageParam.class);
        param.setAction(sealedMessage.getHeader().getOthers().get("businessType"));
        param.setRequestTime(sealedMessage.getHeader().getOthers().get("businessTime"));
        Result<Object> result=null;
        try {
            PageUtils page = accessRecordService.queryForPage(param);
            result = Result.ok(page);
        }catch (Exception exception){
            result = new Result();
            result.setCode(Result.ResultCode.FAILED.getCode());
            result.setMessage(exception.getLocalizedMessage());
        }
        janusUploader.sendJanusCmdResult(getSourceType(), sealedMessage.getHeader().getOthers().get("cmdSerialKey"), result);
    }

    @Override
    public String getSourceType() {
        return "listRequestRecordPage";
    }
}
