package com.xforceplus.janus.framework.record.cmd;

import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.bridgehead.core.monitor.JanusUploader;
import com.xforceplus.janus.framework.cmd.IJanusCmdHandler;
import com.xforceplus.janus.framework.dto.Result;
import com.xforceplus.janus.framework.record.domain.AccessContentDto;
import com.xforceplus.janus.framework.record.domain.AccessRecord;
import com.xforceplus.janus.framework.record.portal.AccessRecordService;
import com.xforceplus.janus.framework.record.portal.RecordRetryHandler;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 将需要重试的请求体发送下来进行重试
 *
 * @Author: xuchuanhou
 * @Date:2022/4/11下午5:42
 */
@Component
public class RequestBodyRetryCmdHandler implements IJanusCmdHandler {

    @Autowired
    JanusUploader janusUploader;

    @Autowired
    private AccessRecordService accessRecordService;

    @Autowired(required = false)
    private RecordRetryHandler recordRetryHandler;

    @Override
    public void doHandler(SealedMessage sealedMessage) {
        String requstTime = sealedMessage.getHeader().getOthers().get("businessTime");
        String recordId = sealedMessage.getHeader().getOthers().get("recordId");
        String content = (String) sealedMessage.getPayload().getObj();
        AccessContentDto accessDto = JacksonUtil.getInstance().fromJson(content, AccessContentDto.class);

        boolean retryResult = false;
        AccessRecord record = accessRecordService.getById(recordId, requstTime);
        record.setAccessContent(accessDto);

        if (recordRetryHandler != null) {
            retryResult = recordRetryHandler.retry(record);
        } else {
            retryResult = accessRecordService.retryAccessRecord(recordId, requstTime);
        }

        Result<Boolean> result = Result.ok(retryResult);
        janusUploader.sendJanusCmdResult(getSourceType(), sealedMessage.getHeader().getOthers().get("cmdSerialKey"), result);
    }

    @Override
    public String getSourceType() {
        return "requestBodyRetry";
    }
}
