package com.xforceplus.janus.framework.record.cmd;

import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.bridgehead.core.monitor.JanusUploader;
import com.xforceplus.janus.framework.cmd.IJanusCmdHandler;
import com.xforceplus.janus.framework.dto.Result;
import com.xforceplus.janus.framework.record.domain.AccessContent;
import com.xforceplus.janus.framework.record.domain.AccessContentDto;
import com.xforceplus.janus.framework.record.portal.AccessRecordService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 命令执行：查询请求履历详情
 * @Author: xuchuanhou
 * @Date:2022/4/8上午10:19
 */
@Component
public class RequestRecordDetailCmdHandler implements IJanusCmdHandler {

    @Autowired
    JanusUploader janusUploader;

    @Autowired
    private AccessRecordService accessRecordService;

    @Override
    public void doHandler(SealedMessage sealedMessage) {
        String requstTime = sealedMessage.getHeader().getOthers().get("businessTime");
        String contentId = sealedMessage.getHeader().getOthers().get("contentId");

        AccessContent content  = accessRecordService.queryByConentId(contentId,requstTime);
        AccessContentDto contenDto = null;
        if(content!=null){
            contenDto  = JacksonUtil.getInstance().fromJson(content.getContent(),AccessContentDto.class);
        }

        Result<AccessContentDto> result = Result.ok(contenDto);
        janusUploader.sendJanusCmdResult(getSourceType(), sealedMessage.getHeader().getOthers().get("cmdSerialKey"), result);
    }

    @Override
    public String getSourceType() {
        return "getRequestRecordDetails";
    }
}
