package com.xforceplus.janus.framework.record.domain;

import org.apache.commons.lang3.time.DateFormatUtils;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.ToString;

/**
 * 请求履历
 *
 * @Date:2022/2/19下午4:04
 */
@Data
@Builder
@ToString
@AllArgsConstructor
public class AccessContent {

    public static final String TABLE_NAME = "t_janus_access_content";

    private String id;

    private String content;

    public static String getTableName() {
        return TABLE_NAME + "_" + DateFormatUtils.format(System.currentTimeMillis(), "yyyyMMdd");
    }

    public static String getTableName(String yyyMMdd) {
        return TABLE_NAME + "_" + yyyMMdd;
    }
}
