package com.xforceplus.janus.framework.record.interceptor;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import lombok.extern.slf4j.Slf4j;

/**
 * @Author: xuchuanhou
 * @Date:2022/2/19下午4:15
 */

@Slf4j
//@Component
@javax.servlet.annotation.WebFilter(urlPatterns = {"/*"})
public class WebFilter implements Filter {

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(
            ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain)
            throws IOException, ServletException {
        ServletRequest request = null;
        ServletResponse cusResponse = null;
        if (servletRequest instanceof HttpServletRequest) {
            request = new CustomHttpServletRequestWrapper((HttpServletRequest) servletRequest);
        }

        if (servletResponse instanceof HttpServletResponse) {
            cusResponse = new CustomHttpServletResponseWrapper((HttpServletResponse) servletResponse);
        }

        if (request == null) {
            chain.doFilter(servletRequest, cusResponse == null ? servletResponse : cusResponse);
        } else {
            chain.doFilter(request, cusResponse == null ? servletResponse : cusResponse);
        }

        if (cusResponse != null) {
            byte[] bytes = ((CustomHttpServletResponseWrapper) cusResponse).getBytes();
            servletResponse.getOutputStream().write(bytes);
        }
    }

    @Override
    public void destroy() {
    }
}
