package com.xforceplus.janus.framework.record.interceptor;


import com.xforceplus.janus.bridgehead.core.config.HttpConfig;
import com.xforceplus.janus.framework.record.portal.AccessRecordConsumer;
import com.xforceplus.janus.framework.record.portal.DbAccessRecordConsumer;
import com.xforceplus.janus.framework.record.portal.LogAccessRecordConsumer;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import java.util.Collections;

import javax.sql.DataSource;

import lombok.extern.slf4j.Slf4j;

/**
 * @Date:2022/3/6下午8:08
 */
@Slf4j
@Configuration
public class WebMvcConfig implements WebMvcConfigurer {

    @Autowired
    private RequestInterceptor requestInterceptor;

    @Autowired
    private HttpConfig httpConfig;

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        if (httpConfig.isWebFielterOff()) {
            return;
        }


        String[] excludePathPatterns = new String[]{"/**.html", "/**.js", "/janus/record/resend", "/error"};
        if (StringUtils.isNotBlank(httpConfig.getWebFilterExclude())) {
            excludePathPatterns = ArrayUtils.addAll(excludePathPatterns, httpConfig.getWebFilterExclude().split(","));
        }

        registry
                .addInterceptor(requestInterceptor)
                .addPathPatterns("/**")
                .excludePathPatterns(excludePathPatterns);
    }


    @ConditionalOnMissingBean(NamedParameterJdbcTemplate.class)
    @Bean
    public NamedParameterJdbcTemplate namedParameterJdbcTemplate(DataSource dataSource) {
        NamedParameterJdbcTemplate template = new NamedParameterJdbcTemplate(dataSource);
        return template;
    }

    @Bean
    @ConditionalOnProperty(prefix = "janus.access", name = "persist", havingValue = "db")
    public AccessRecordConsumer dbAccConsumer() {
        return new DbAccessRecordConsumer();
    }

    @Bean
    @ConditionalOnMissingBean(AccessRecordConsumer.class)
    public AccessRecordConsumer logAccConsumer() {
        return new LogAccessRecordConsumer();
    }

    @Bean
    @ConditionalOnProperty(prefix = "janus", name = "webFielterOff",havingValue = "false",matchIfMissing = false)
    FilterRegistrationBean<WebFilter> myFilterFilterRegistrationBean() {
        FilterRegistrationBean<WebFilter> bean = new FilterRegistrationBean<>();
        bean.setFilter(new WebFilter());
        bean.setOrder(-1);
        bean.setUrlPatterns(Collections.singletonList("/*"));
        return bean;
    }

}
