package com.xforceplus.janus.framework.record.portal;

import com.xforceplus.apollo.utils.BeanMapperUtil;
import com.xforceplus.janus.bridgehead.core.util.SpringContextUtils;
import com.xforceplus.janus.framework.record.domain.AccessRecord;
import com.xforceplus.janus.framework.util.PageUtils;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author: xuchuanhou
 * @Date:2022/3/16下午2:49
 */
@Repository
public class AccessRecordRepository {

    @Autowired(required = false)
    private NamedParameterJdbcTemplate namedPrmtrJdbcTemplate;

    @Autowired
    private JdbcTemplate jdbcTemplate;

    public void saveBatch(List<AccessRecord> records) {
        Map<String, Object>[] params = new Map[records.size()];
        List<Map> rcMaps = BeanMapperUtil.mapList(records, Map.class);

        rcMaps.toArray(params);

        if (namedPrmtrJdbcTemplate == null) {
            namedPrmtrJdbcTemplate = SpringContextUtils.getBean(NamedParameterJdbcTemplate.class);
        }
        namedPrmtrJdbcTemplate.batchUpdate(getInsertSql(), params);
    }


    private String getInsertSql() {
        StringBuilder builder = new StringBuilder();
        builder.append("insert into ").append(AccessRecord.getTableName()).append("(");
        builder.append(
                "id,request_method,client_project_id,server_project_id,api_id,action,cost_time,status,content_id,trace_id,serial_no,source_ip,request_time,req_data_len,rep_data_len").append(")values(");
        builder.append(
                ":id,:requestMethod,:clientProjectId,:serverProjectId,:apiId,:action,:costTime,:status,:contentId,:traceId,:serialNo,:sourceIp,:requestTime,:reqDataLen,:repDataLen").append(")");

        return builder.toString();
    }

    private static final String QUERYSQL = "select id,request_method,client_project_id,server_project_id,api_id,action,cost_time,status,content_id,trace_id,serial_no,source_ip,request_time,req_data_len,rep_data_len from %s where 1=1 ";
    private static final String queryByIdSql = QUERYSQL + " and  id=:id";

    private static final String QUERYCOUNTSQL = "select count(1) from %s where 1=1";


    public AccessRecord getById(String id, String yyyyMMdd) {
        String tableName = StringUtils.isBlank(yyyyMMdd) ? AccessRecord.getTableName() : AccessRecord.getTableName(yyyyMMdd);

        String querySql = String.format(queryByIdSql, tableName);
        Map<String, Object> param = new HashMap<String, Object>() {{
            put("id", id);
        }};
        AccessRecord acc = namedPrmtrJdbcTemplate.queryForObject(querySql, param, new RowMapper<AccessRecord>() {
            @Override
            public AccessRecord mapRow(ResultSet rs, int rowNum) throws SQLException {
                AccessRecord.AccessRecordBuilder builder = AccessRecord.builder();
                builder.id(rs.getString("id"))
                        .requestMethod(rs.getString("request_method"))
                        .action(rs.getString("action"))
                        .apiId(rs.getString("api_id"))
                        .traceId(rs.getString("trace_id"))
                        .reqDataLen(rs.getInt("req_data_len"))
                        .repDataLen(rs.getInt("rep_data_len"))
                        .serialNo(rs.getString("serial_no"))
                        .requestTime(rs.getString("request_time"))
                        .sourceIp(rs.getString("source_ip"))
                        .contentId(rs.getString("content_id"))
                        .status(rs.getInt("status"))
                        .clientProjectId(rs.getString("client_project_id"))
                        .serverProjectId(rs.getString("server_project_id"))
                        .costTime(rs.getLong("cost_time"))
                ;

                return builder.build();
            }
        });
        return acc;
    }

    public PageUtils queryForPage(String action, String requestTime, String serialNo, int page ,int size) {
        String yyyyMMd = requestTime.replaceAll("-", "").substring(0, 8);
        if (requestTime.length() == 13) {

        } else if (requestTime.length() == 11) {
        } else if (requestTime.length() == 9) {
        }
        String tableName = StringUtils.isBlank(yyyyMMd) ? AccessRecord.getTableName() : AccessRecord.getTableName(yyyyMMd);

        String querySql = String.format(QUERYSQL, tableName);
        String queryCountSql = String.format(QUERYCOUNTSQL, tableName);

        Map<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(action)) {
            querySql += " and action=:action";
            queryCountSql+= " and action=:action";
            params.put("action", action);

        }

        if (StringUtils.isNotBlank(serialNo)) {
            querySql += " and serial_no=:serialNo";
            queryCountSql += " and serial_no=:serialNo";
            params.put("serialNo", serialNo);
        }

       Integer rows =  namedPrmtrJdbcTemplate.queryForObject(queryCountSql,params,Integer.class);

        List<AccessRecord> accs =null;
        if(rows>0){
            if(page<=1){
                querySql+=" limit 0,"+size;
            }else{
                querySql+=" limit "+((page-1)*size)+","+size;
            }

            accs= namedPrmtrJdbcTemplate.query(querySql, params, new RowMapper<AccessRecord>() {
                @Override
                public AccessRecord mapRow(ResultSet rs, int rowNum) throws SQLException {
                    AccessRecord.AccessRecordBuilder builder = AccessRecord.builder();
                    builder.id(rs.getString("id"))
                            .requestMethod(rs.getString("request_method"))
                            .action(rs.getString("action"))
                            .apiId(rs.getString("api_id"))
                            .traceId(rs.getString("trace_id"))
                            .reqDataLen(rs.getInt("req_data_len"))
                            .repDataLen(rs.getInt("rep_data_len"))
                            .serialNo(rs.getString("serial_no"))
                            .requestTime(rs.getString("request_time"))
                            .sourceIp(rs.getString("source_ip"))
                            .contentId(rs.getString("content_id"))
                            .status(rs.getInt("status"))
                            .clientProjectId(rs.getString("client_project_id"))
                            .serverProjectId(rs.getString("server_project_id"))
                            .costTime(rs.getLong("cost_time"))
                    ;
                    return builder.build();
                }
            });
        }
        PageUtils pageUtils = new PageUtils(accs, rows, size, page);
        return pageUtils;

    }

}
