package com.xforceplus.janus.framework.record.portal;

import com.xforceplus.janus.bridgehead.core.monitor.JanusUploader;
import com.xforceplus.janus.bridgehead.core.monitor.param.MonitorParam;
import com.xforceplus.janus.framework.record.cache.AccessRecordCache;
import com.xforceplus.janus.framework.record.domain.AccessRecord;

import org.apache.commons.collections.CollectionUtils;
import org.apache.http.HttpStatus;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

import lombok.extern.slf4j.Slf4j;

/**
 * @Author: xuchuanhou
 * @Date:2022/3/5下午2:03
 */
@Slf4j
public class DbAccessRecordConsumer implements AccessRecordConsumer {

    @Autowired
    private AccessRecordService accessRecordService;

    @Autowired
    private JanusUploader janusUploader;

    @Override
    public void consumeAccessRecord() {
        while (true) {
            try {
                List<AccessRecord> records = AccessRecordCache.takeBatch();
                if (CollectionUtils.isEmpty(records)) {
                    continue;
                }
                accessRecordService.saveBatch(records);
                // 判断内容进行 异常监控发送到云端
                for (AccessRecord record : records) {
                    if (record.getStatus() != HttpStatus.SC_OK) {
                        this.noticeException(record);
                    }
                }
            } catch (InterruptedException exception) {
            } catch (Throwable tr) {
                log.error("saveBatch  AccessRecord error", tr);
            }
        }
    }

    long lastSendTime = 0;

    public void noticeException(AccessRecord record) {
        if (lastSendTime > 0 && (System.currentTimeMillis() - lastSendTime) < 3600000) {
            return;
        }

        MonitorParam monitorParam = new MonitorParam();
        monitorParam.setDataType(MonitorParam.DATA_TYPE_HTTP);
        monitorParam.setNoticeType(MonitorParam.NOTICE_TYPE_EMAIL);
        monitorParam.setNoticeContent(String.format("接口[%s]异常，状态码:%d", record.getAction(), record.getStatus()));
        monitorParam.setSubject("服务无接口异常");
        monitorParam.setMonitorType(MonitorParam.MONITOR_TYPE_SERVICE);
        janusUploader.uploadMonitor(monitorParam);
    }


}
