package com.xforceplus.janus.framework.record.portal;

import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.janus.framework.record.cache.AccessRecordCache;
import com.xforceplus.janus.framework.record.domain.AccessRecord;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class LogAccessRecordConsumer implements AccessRecordConsumer {

    @Override
    public void consumeAccessRecord() {

        while (true) {
            try {
                AccessRecord record = AccessRecordCache.takeRecord();
                log.info(record.toString());
            } catch (InterruptedException exception) {
                log.error(ErrorUtil.getStackMsg(exception));
            } catch (Throwable tr) {

            }
        }


    }
}
