package com.xforceplus.janus.framework.record.web;


import com.xforceplus.janus.framework.record.portal.AccessRecordService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author: xuchuanhou
 * @Date:2022/3/17下午3:18
 */
@RestController
@RequestMapping("/janus/record")
public class AccessRecordController {

    @Autowired
    AccessRecordService accessRecordService;

    @ResponseBody
    @PostMapping("/resend")
    public Map<String, Object> resend(@RequestParam String id, @RequestParam(required = false) String yyyyMMdd) {
        Map<String, Object> result = new HashMap<>();
        boolean isSuccess = accessRecordService.retryAccessRecord(id, yyyyMMdd);
        result.put("code", isSuccess ? "1" : "0");
        return result;
    }
}
