package com.xforceplus.janus.generator.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * 对象属性表
 *
 * @author 许传厚
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class ModelPropertyDto implements Serializable {
    /**
     * 字段名称
     */
    private String name;
    /**
     * 字段说明字段类型
     */
    private String type;
    private String mustFill;
    /**
     * 字段说明
     */
    private String describe;
    private String refClassName;
    /**
     * mock value
     */
    private String deValue;
    private String len;

    private List<ModelPropertyDto> children;

    /**
     * 前端页面使用 级联使用 name/name
     */
    private String key;

    public ModelPropertyDto() {
    }

    public ModelPropertyDto(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public ModelPropertyDto(String name, String type, String deValue) {
        this.name = name;
        this.type = type;
        this.deValue = deValue;
    }

    public ModelPropertyDto(String name, String type, String deValue, String key) {
        this.name = name;
        this.type = type;
        this.deValue = deValue;
        this.key = key;
    }


}