package com.xforceplus.janus.generator.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.xforceplus.janus.generator.domain.GenTableColumn;

import java.util.Collection;
import java.util.List;

/**
 * 业务字段 服务层
 * 
 * @author just
 */
public interface IGenTableColumnService extends IService<GenTableColumn>
{
    /**
     * 查询业务字段列表
     * 
     * @param tableId  表ID
     * @return 业务字段集合
     */
    List<GenTableColumn> selectGenTableColumnListByTableId(Long tableId);


    /**
     * 删除业务字段信息
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
     int deleteGenTableColumnByIds(String ids);

    boolean deleteGenTableColumnByIds(Collection<Long> ids);

    /**
     * 根据表ID 删除对象
     * @param id
     * @return
     */
    boolean deleteByTableId(long id);


    /**
     *
    * @author xucuanhou
    * @date 2021/12/30
     */
    boolean saveOrUpdateColumn(GenTableColumn column);

    GenTableColumn queryByColName(Long tableId,String columnName);
}
