package com.xforceplus.janus.generator.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.xforceplus.janus.commons.util.PageUtils;
import com.xforceplus.janus.generator.domain.GenTable;
import com.xforceplus.janus.generator.param.GenTableParam;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipOutputStream;

/**
 * 业务 服务层
 * 
 * @author just
 */
public interface IGenTableService extends IService<GenTable>
{
    /**
     * 查询业务列表
     * 
     * @param genTable 业务信息
     * @return 业务集合
     */
     List<GenTable> selectGenTableList(GenTable genTable);


     /***/
     boolean saveOrUpdateGenTable(GenTable genTable);





     PageUtils queryPager(GenTableParam param);

    /**
     * 查询据库列表
     * 
     * @param genTable 业务信息
     * @return 数据库表集合
     */
     List<GenTable> selectDbTableList(GenTable genTable);



    /**
     * 查询据库列表
     * 
     * @param tableNames 表名称组
     * @return 数据库表集合
     */
     List<GenTable> selectDbTableListByNames(String[] tableNames);

     GenTable selectGenTableName(String tableName,String projectId);

    GenTable selectSimpleGenTableName(String tableName,String projectId);

    GenTable getRichById(String id);

    /**
     * 根据业务名称查询明细
     * @param businessName
     * @return
     */
    GenTable getRichByBusinessName(String businessName);

    /**
     * 修改业务
     * 
     * @param genTable 业务信息
     * @return 结果
     */
     void updateGenTable(GenTable genTable);

    /**
     * 删除业务信息
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
     void deleteGenTableByIds(String ids);

    /**
     * 根据ID 删除
     * @param id
     */
    void deleteGenTableById(long id);

    /**
     * 导入表结构
     * 
     * @param tableList 导入表列表
     * @param operName 操作人员
     */
     void importGenTable(List<GenTable> tableList, String operName);

    /**
     * 预览代码
     * 
     * @param tableId 表编号
     * @return 预览数据列表
     */
     Map<String, String> previewCode(Long tableId);

    /**
     * 生成代码
     * 
     * @param tableName 表名称
     * @return 数据
     */
     byte[] generatorCode(String tableName,String projectId,String projectCode) throws IOException;

     void generatorCode(String tableName, String projectId,String projectCode,ZipOutputStream zip) throws IOException;

     GenTable findByTbNameProjectId(String tbName,String projectId);

    /**
     * 批量生成代码
     * 
     * @param tableNames 表数组
     * @return 数据
     */
     byte[] generatorCode(String[] tableNames,String projectId,String projectCode) throws IOException;


}
