package com.xforceplus.janus.generator.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class ProduceUtils {

    /**
     * 获取Object 数据类型
     * @param object
     * @return
     */
    public static String getType(Object object){
        String typeName=object.getClass().getName();
        int length= typeName.lastIndexOf(".");
        String type = typeName.substring(length + 1);
        switch (type) {
            case "LinkedHashMap":
                type = "Map<String, Object>";
                break;
            case "ArrayList":
                type = "List<Object>";
                break;
            default:
                break;
        }
        return type;
    }

    /**
     * 提取{}中内容，忽略{}号中的{}号
     * @param msg
     * @return
     */
    public static List<String> fetchMsg(String msg) {
        List<String> list = new ArrayList<>();
        int start = 0;
        int startFlag = 0;
        int endFlag = 0;
        for (int i = 0; i < msg.length(); i++) {
            if (msg.charAt(i) == '{') {
                startFlag++;
                if (startFlag == endFlag + 1) {
                    start = i;
                }
            } else if (msg.charAt(i) == '}') {
                endFlag++;
                if (endFlag == startFlag) {
                    list.add(msg.substring(start + 1, i));
                }
            }
        }
        return list;
    }

    public static String getRandomString(int length){
        String str="abcdefghijklmnopqrstuvwxyz";
        Random random=new Random();
        StringBuffer sb=new StringBuffer();
        for(int i = 0;i < length; i++){
            int number=random.nextInt(26);
            sb.append(str.charAt(number));
        }
        return sb.toString();
    }
}
