package com.xforceplus.janus.generator.util;

import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.common.utils.DateUtils;
import com.xforceplus.janus.common.utils.StringUtils;
import com.xforceplus.janus.generator.config.GenConfig;
import com.xforceplus.janus.generator.constant.GenConstants;
import com.xforceplus.janus.generator.domain.ApiContentModel;
import com.xforceplus.janus.generator.domain.ApiModel;
import com.xforceplus.janus.generator.domain.ApisInfo;
import com.xforceplus.janus.generator.domain.GenTable;
import com.xforceplus.janus.generator.domain.GenTableColumn;
import com.xforceplus.janus.generator.dto.PathVariableDto;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.velocity.VelocityContext;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class VelocityUtils {

    /**
     * mybatis空间路径
     */
    private static final String MYBATIS_PATH = "main/resources/mapper";


    public static VelocityContext prepareContextController(String moduleName, List<ApisInfo> apisInfos) {
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("businessName", moduleName.toLowerCase());
        velocityContext.put("ClassName", moduleName);
        velocityContext.put("serviceName", "janusService");
        List<ApiContentModel> controllerModels = new ArrayList<>();
        velocityContext.put("apis", controllerModels);
        ApiContentModel model;
        for (ApisInfo info : apisInfos) {
            if (null == info.getRestEntity()) {
                continue;
            }
            if ("service".equals(info.getSourceType()) || ("authority".equals(info.getSourceType()) && !"TCP".equalsIgnoreCase(info.getProtocol()))) {
                model = new ApiContentModel();
                model.setMethodName(info.getRequestPath());
                model.setMethodType(info.getRequestMethod());
                //
                model.setPathVariables(fetchPathVaiableDto(info.getRequestPath()));

                model.setServiceMethod(ProduceUtils.getRandomString(8));
                model.setRequestModel(info.getReqModel());
                model.setResponseModel(StringUtils.isNotBlank(info.getRespModel()) ? info.getRespModel() : "void");
                model.setFunctionName(info.getName());
                model.setUiaSign(info.getUiaSign());
                controllerModels.add(model);
            }

        }
        return CollectionUtils.isNotEmpty(controllerModels) ? velocityContext : null;
    }

    /**
     * 设置模板变量信息
     *
     * @return 模板列表
     */
    public static VelocityContext prepareContext(GenTable genTable) {
        String moduleName = genTable.getModuleName();
        String businessName = genTable.getBusinessName();
        String packageName = genTable.getPackageName();
        String tplCategory = genTable.getTplCategory();
        String functionName = genTable.getFunctionName();

        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("tplCategory", genTable.getTplCategory());
        velocityContext.put("tableName", genTable.getTableName());
        velocityContext.put("functionName", StringUtils.isNoneBlank(functionName) ? functionName : genTable.getRemark());
        velocityContext.put("ClassName", genTable.getClassName());
        velocityContext.put("className", StringUtils.uncapitalize(genTable.getClassName()));
        velocityContext.put("moduleName", genTable.getModuleName());
        velocityContext.put("businessName", genTable.getBusinessName());
        velocityContext.put("basePackage", getPackagePrefix(packageName));
        velocityContext.put("packageName", packageName);
        velocityContext.put("author", genTable.getFunctionAuthor());
        velocityContext.put("datetime", DateUtils.getDate());
        velocityContext.put("pkColumn", genTable.getPkColumn());
        velocityContext.put("importList", getImportList(genTable.getColumns()));
        velocityContext.put("permissionPrefix", getPermissionPrefix(moduleName, businessName));
        velocityContext.put("columns", genTable.getColumns());
        velocityContext.put("table", genTable);
        if (GenConstants.TPL_TREE.equals(tplCategory)) {
            setTreeVelocityContext(velocityContext, genTable);
        }
//        if (GenConstants.TPL_SUB.equals(tplCategory)) {
//            velocityContext.put("subClassFieldName", genTable.getSubClassFieldName());
//            velocityContext.put("SubClassFieldName", StringUtils.capitalize(genTable.getSubClassFieldName()));
//            setSubVelocityContext(velocityContext, genTable);
//
//        }
        return velocityContext;
    }

    public static void setTreeVelocityContext(VelocityContext context, GenTable genTable) {
        String options = genTable.getOptions();
        Map paramsObj = JacksonUtil.getInstance().fromJson(options, HashMap.class);
        String treeCode = getTreecode(paramsObj);
        String treeParentCode = getTreeParentCode(paramsObj);
        String treeName = getTreeName(paramsObj);

        context.put("treeCode", treeCode);
        context.put("treeParentCode", treeParentCode);
        context.put("treeName", treeName);
        context.put("expandColumn", getExpandColumn(genTable));
        if (paramsObj.containsKey(GenConstants.TREE_PARENT_CODE)) {
            context.put("tree_parent_code", MapUtils.getString(paramsObj, GenConstants.TREE_PARENT_CODE));
        }
        if (paramsObj.containsKey(GenConstants.TREE_NAME)) {
            context.put("tree_name", MapUtils.getString(paramsObj, GenConstants.TREE_NAME));
        }


    }

//    public static void setSubVelocityContext(VelocityContext context, GenTable genTable)
//    {
//        GenTable subTable = genTable.getSubTable();
//        String subTableName = genTable.getSubTableName();
//        String subTableFkName = genTable.getSubTableFkName();
//        String subClassName = genTable.getSubTable().getClassName();
//        String subTableFkClassName = StringUtils.convertToCamelCase(subTableFkName);
//        if(StringUtils.isNotBlank(subTableFkName)&&CollectionUtils.isNotEmpty(subTable.getColumns())){
//            for (GenTableColumn column:subTable.getColumns()){
//                if(column.getColumnName().equals(subTableFkName)){
//                    subTableFkClassName = column.getJavaField();
//                    break;
//                }
//            }
//        }
//
//
//        context.put("subTable", subTable);
//        context.put("subTableName", subTableName);
//        context.put("subTableFkName", subTableFkName);
//        context.put("SubTableFkClassName", StringUtils.capitalize(subTableFkClassName));
//        context.put("subTableFkClassName", subTableFkClassName );
//        context.put("SubClassName", subClassName);
//        context.put("subColumns", subTable.getColumns());
//        context.put("subclassName", StringUtils.uncapitalize(subClassName));
//
//        context.put("subImportList", getImportList(genTable.getSubTable()));
//    }


    /**
     * 获取CRUD 模板信息
     *
     * @return 模板列表
     */
    @Deprecated
    public static List<String> getCrudTemplateList(String tplCategory) {
        List<String> templates = new ArrayList<String>();
//        templates.add("vm/java/crud/domain.java.vm");
//        templates.add("vm/java/crud/domain.java.vm");
//        templates.add("vm/java/crud/pageDto.java.vm");
//        templates.add("vm/java/crud/dao.java.vm");
//        templates.add("vm/java/crud/service.java.vm");
        templates.add("vm/java/crud/serviceImpl.java.vm");
//        templates.add("vm/java/crud/controller.java.vm");
//        templates.add("vm/java/crud/sql.vm");
//        if (GenConstants.TPL_CRUD.equals(tplCategory)||GenConstants.TPL_SUB.equals(tplCategory))
//        {
//            templates.add("vm/html/list.html.vm");
//        }
//        else if (GenConstants.TPL_TREE.equals(tplCategory))
//        {
//            templates.add("vm/html/tree.html.vm");
//            templates.add("vm/html/list-tree.html.vm");
//        }
//        templates.add("vm/html/add.html.vm");
//        templates.add("vm/html/edit.html.vm");

        return templates;
    }

    /**
     * 获取文件名
     */
    public static String getFileName(String template, GenTable genTable, String projectCode) {
        // 文件名称
        String fileName = "";
        // 包路径
        String packageName = genTable.getPackageName();
        // 模块名
        String moduleName = genTable.getModuleName();
        // 大写类名
        String className = genTable.getClassName();
        // 业务名称
        String businessName = genTable.getBusinessName();

        String javaPath = "bridgehead-" + projectCode + "/src/main/java/com/xforceplus/janus/bridgehead/" + projectCode;
        String mybatisPath = MYBATIS_PATH + "/" + moduleName;
        String htmlPath = "bridgehead-" + projectCode + "/src/main/resources/templates/" + moduleName;

        if (template.contains("domain.java.vm")) {
            fileName = String.format("%s/domain/%s.java", javaPath, className);
        }
        if (template.contains("pageDto.java.vm")) {
            fileName = String.format("%s/dto/%sPageDto.java", javaPath, className);
        } else if (template.contains("dao.java.vm")) {
            fileName = String.format("%s/dao/%sDao.java", javaPath, className);
        } else if (template.contains("service.java.vm")) {
            fileName = String.format("%s/service/I%sService.java", javaPath, className);
        } else if (template.contains("serviceImpl.java.vm")) {
            fileName = String.format("%s/service/impl/%sServiceImpl.java", javaPath, className);
        } else if (template.contains("controller.java.vm")) {
            fileName = String.format("%s/controller/%s/%sController.java", javaPath, moduleName, className);
        } else if (template.contains("mapper.xml.vm")) {
            fileName = String.format("%s/%sMapper.xml", mybatisPath, className);
        } else if (template.contains("list.html.vm")) {
            fileName = String.format("%s/%s.html", htmlPath, businessName);
        } else if (template.contains("list-tree.html.vm")) {
            fileName = String.format("%s/%s.html", htmlPath, businessName);
        }
//        else if (template.contains("tree.html.vm"))
//        {
//            fileName = String.format("%s/tree.html", htmlPath);
//        }
//        else if (template.contains("add.html.vm"))
//        {
//            fileName = String.format("%s/add.html", htmlPath);
//        }
//        else if (template.contains("edit.html.vm"))
//        {
//            fileName = String.format("%s/edit.html", htmlPath);
//        }
        else if (template.contains("sql.vm")) {
            fileName = String.format("%s/doc/sql/%sMenu.sql", "bridgehead-" + projectCode, businessName);
        }
        return fileName;
    }


    /**
     * 根据列类型获取导入包
     *
     * @param genTable 业务表对象
     * @return 返回需要导入的包列表
     */
//    public static HashSet<String> getImportList(GenTable genTable)
//    {
//        List<GenTableColumn> columns = genTable.getColumns();
//        GenTable subGenTable = genTable.getSubTable();
//        HashSet<String> importList = new HashSet<String>();
//        if (subGenTable!=null)
//        {
//            importList.add("java.util.List");
//        }
//        for (GenTableColumn column : columns)
//        {
//            if (!column.isSuperColumn() && GenConstants.TYPE_DATE.equals(column.getJavaType()))
//            {
//                importList.add("java.util.Date");
//            }
//            else if (!column.isSuperColumn() && GenConstants.TYPE_BIGDECIMAL.equals(column.getJavaType()))
//            {
//                importList.add("java.math.BigDecimal");
//            }
//        }
//        return importList;
//    }

    /**
     * 获取项目文件路径
     *
     * @return 路径
     */
    public static String getProjectPath() {
        String packageName = GenConfig.packageName;
        StringBuffer projectPath = new StringBuffer();
        projectPath.append("main/java/");
        projectPath.append(packageName.replace(".", "/"));
        projectPath.append("/");
        return projectPath.toString();
    }

    /**
     * 获取包前缀
     *
     * @param packageName 包名称
     * @return 包前缀名称
     */
    public static String getPackagePrefix(String packageName) {
        int lastIndex = packageName.lastIndexOf(".");
        String basePackage = StringUtils.substring(packageName, 0, lastIndex);
        return basePackage;
    }

    /**
     * 根据列类型获取导入包
     *
     * @param columns 列集合
     * @return 返回需要导入的包列表
     */
    public static HashSet<String> getImportList(List<GenTableColumn> columns) {
        HashSet<String> importList = new HashSet<String>();
        for (GenTableColumn column : columns) {
            if (!column.isSuperColumn() && GenConstants.TYPE_DATE.equals(column.getJavaType())) {
                importList.add("java.util.Date");
            } else if (!column.isSuperColumn() && GenConstants.TYPE_BIGDECIMAL.equals(column.getJavaType())) {
                importList.add("java.math.BigDecimal");
            }
        }
        return importList;
    }

    /**
     * 获取权限前缀
     *
     * @param moduleName   模块名称
     * @param businessName 业务名称
     * @return 返回权限前缀
     */
    public static String getPermissionPrefix(String moduleName, String businessName) {
        return String.format("{}:{}", moduleName, businessName);

    }

    /**
     * 获取树编码
     *
     * @param paramsObj 生成其他选项
     * @return 树编码
     */
    public static String getTreecode(Map paramsObj) {
        if (paramsObj.containsKey(GenConstants.TREE_CODE)) {
            return StringUtils.toCamelCase(MapUtils.getString(paramsObj, GenConstants.TREE_CODE));
        }
        return "";
    }

    /**
     * 获取树父编码
     *
     * @param paramsObj 生成其他选项
     * @return 树父编码
     */
    public static String getTreeParentCode(Map paramsObj) {
        if (paramsObj.containsKey(GenConstants.TREE_PARENT_CODE)) {
            return StringUtils.toCamelCase(MapUtils.getString(paramsObj, GenConstants.TREE_PARENT_CODE));
        }
        return "";
    }

    /**
     * 获取树名称
     *
     * @param paramsObj 生成其他选项
     * @return 树名称
     */
    public static String getTreeName(Map paramsObj) {
        if (paramsObj.containsKey(GenConstants.TREE_NAME)) {
            return StringUtils.toCamelCase(MapUtils.getString(paramsObj, GenConstants.TREE_NAME));
        }
        return "";
    }

    /**
     * 获取需要在哪一列上面显示展开按钮
     *
     * @param genTable 业务表对象
     * @return 展开按钮列序号
     */
    public static int getExpandColumn(GenTable genTable) {
        String options = genTable.getOptions();
        Map paramsObj = JacksonUtil.getInstance().fromJson(options, HashMap.class);
        String treeName = MapUtils.getString(paramsObj, GenConstants.TREE_NAME);
        int num = 0;
        for (GenTableColumn column : genTable.getColumns()) {
            if (column.isList()) {
                num++;
                String columnName = column.getColumnName();
                if (columnName.equals(treeName)) {
                    break;
                }
            }
        }
        return num;
    }


    public static VelocityContext prepareContextService(String moduleName, List<ApisInfo> apisInfos) {
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("businessName", moduleName.toLowerCase());
        velocityContext.put("ClassName", moduleName);
        velocityContext.put("serviceName", "janusService");
        List<ApiContentModel> controllerModels = new ArrayList<>();
        velocityContext.put("apis", controllerModels);
        ApiContentModel model;
        boolean isNetty = false;
        for (ApisInfo info : apisInfos) {
            if (null == info.getRestEntity()) {
                continue;
            }

            if ("xml".equalsIgnoreCase(info.getContentType()) || "text/xml".equalsIgnoreCase(info.getContentType())) {
                continue;
            }
            if (!isNetty && "TCP".equalsIgnoreCase(info.getOutType())) {
                isNetty = true;
            }
            model = new ApiContentModel(info.getSourceType(), info.getName(), info.getRequestPath(), info.getRequestMethod(), info.getAction());
            model.setIsNetty("TCP".equalsIgnoreCase(info.getSourceType()));
            model.setPathVariables(fetchPathVaiableDto(info.getRequestPath()));

            model.setServiceMethod(ProduceUtils.getRandomString(8));
            model.setRequestModel(info.getReqModel());
            model.setFlowId(info.getFlowId());

            model.setAuthentication(info.getAuthentication());
            model.setUiaSign(info.getUiaSign());

            model.setResponseModel(StringUtils.isNotBlank(info.getRespModel()) ? info.getRespModel() : "void");
            controllerModels.add(model);

        }
        velocityContext.put("isNetty", isNetty);
        return velocityContext;
    }

    public static VelocityContext prepareContextSoap(List<ApisInfo> apisInfos) {
        VelocityContext velocityContext = new VelocityContext();
        List<ApiContentModel> controllerModels = new ArrayList<>();
        velocityContext.put("apis", controllerModels);
        ApiContentModel model;
        for (ApisInfo info : apisInfos) {
            if (null == info.getRestEntity()) {
                continue;
            }
            model = new ApiContentModel();
            if ("json".equalsIgnoreCase(info.getContentType()) || "application/json".equalsIgnoreCase(info.getContentType())) {
                continue;
            }

            model.setSourceType(info.getSourceType());
            model.setMethodName(info.getRequestPath());
            model.setMethodType(info.getRequestMethod());
            model.setPathVariables(fetchPathVaiableDto(info.getRequestPath()));
            model.setServiceMethod(ProduceUtils.getRandomString(8));
            model.setRequestModel(info.getReqModel());
            model.setAction(info.getAction());
            model.setResponseModel(StringUtils.isNotBlank(info.getRespModel()) ? info.getRespModel() : "void");
            model.setFunctionName(info.getName());
            model.setUiaSign(info.getUiaSign());
            controllerModels.add(model);
        }
        return CollectionUtils.isNotEmpty(controllerModels) ? velocityContext : null;
    }

    private static List<PathVariableDto> fetchPathVaiableDto(String pathvariable) {
        List<String> pathvales = ProduceUtils.fetchMsg(pathvariable);
        if (CollectionUtils.isNotEmpty(pathvales)) {
            List<PathVariableDto> pathVars = new ArrayList<>();
            pathvales.forEach(pathva -> {
                pathVars.add(new PathVariableDto(pathva, StringUtils.toCamelCase(pathva.replaceAll("-", "_"))));
            });
            return pathVars;
        }

        return null;
    }


    public static VelocityContext prepareContextModel(String name, List<ApiModel> models) {
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("ClassName", name);
        velocityContext.put("models", models);
        return velocityContext;
    }

    public static VelocityContext prepareContextNetty(String clientId, String tcpUrl, Integer port, List<ApisInfo> apisInfos) {
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("userId", clientId);
        velocityContext.put("tcpUrl", tcpUrl);
        velocityContext.put("port", port);
        return velocityContext;
    }

    /**
     * 根据接口定义中消息体JSON 生成 对象模型
     *
     * @author xuchuanhou
     */
    public static List<ApiModel> createApiModel(String jsonBody) {
        Map<String, Object> map = JacksonUtil.getInstance().fromJson(jsonBody, Map.class);
        ApiModel model;
        List<ApiModel> params = new ArrayList<>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == null) {
                continue;
            }

            Object mapValue = entry.getValue();
            model = new ApiModel(entry.getKey());
            model.setDataType(ProduceUtils.getType(mapValue));
            params.add(model);
        }
        return params;
    }
}