/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.message.common.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.janus.message.common.utils.ZipUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotEmpty;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

@ApiModel(value="\u8bf7\u6c42\u6d88\u606f")
@JsonIgnoreProperties(ignoreUnknown=true)
public class RequestMessage
implements Serializable {
    public static final String COMPRESS_FLAG = "compressFlag";
    public static final String COMPRESS_FLAG_FALSE = "false";
    public static final String COMPRESS_FLAG_TRUE = "true";
    @ApiModelProperty(value="\u6d88\u606f\u5185\u5bb9", required=true, notes="\u683c\u5f0f\u4e3a\u5b57\u7b26\u4e32")
    @NotEmpty
    private String content;
    @ApiModelProperty(value="\u6d88\u606f\u5c5e\u6027Map", required=false)
    private Map<String, String> properties;
    @ApiModelProperty(value="\u53d1\u9001\u65f6\u95f4\u6233\uff0c\u7528\u6765\u8bb0\u5f55\u751f\u4ea7\u8005\u53d1\u9001\u6d88\u606f\u65f6\u95f4\u70b9", required=false, example="1614930380000")
    private long sentTime;

    public Map<String, String> getProperties() {
        if (MapUtils.isEmpty(this.properties)) {
            this.properties = new HashMap<String, String>();
        }
        return this.properties;
    }

    public String checkProperties(List<String> checkAttrNames) {
        if (CollectionUtils.isEmpty(checkAttrNames)) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        Map<String, String> properties = this.getProperties();
        for (String attrName : checkAttrNames) {
            if (properties.containsKey(attrName)) continue;
            result.append(attrName + " \u5c5e\u6027\u5fc5\u586b");
        }
        return result.toString();
    }

    public void ungzip() {
        if (COMPRESS_FLAG_TRUE.equals(this.getProperties().get(COMPRESS_FLAG))) {
            this.content = ZipUtil.ungzip(this.content);
            this.getProperties().remove(COMPRESS_FLAG);
        }
    }

    public String getContent() {
        return this.content;
    }

    public long getSentTime() {
        return this.sentTime;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setSentTime(long sentTime) {
        this.sentTime = sentTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestMessage)) {
            return false;
        }
        RequestMessage other = (RequestMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        return this.getSentTime() == other.getSentTime();
    }

    protected boolean canEqual(Object other) {
        return other instanceof RequestMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        long $sentTime = this.getSentTime();
        result = result * 59 + (int)($sentTime >>> 32 ^ $sentTime);
        return result;
    }

    public String toString() {
        return "RequestMessage(content=" + this.getContent() + ", properties=" + this.getProperties() + ", sentTime=" + this.getSentTime() + ")";
    }
}

