/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.message.common.config;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Component
@ConfigurationProperties(prefix="application", ignoreUnknownFields=true)
@Validated
public class ApplicationProperties {
    private static final Logger log = LoggerFactory.getLogger(ApplicationProperties.class);
    private final ApplicationContext applicationContext;
    private final Http http = new Http();
    private final Swagger swagger = new Swagger();
    private final ElapsedTimeLogging elapsedTimeLogging = new ElapsedTimeLogging();
    private final AopLogging aopLogging = new AopLogging();

    public ApplicationProperties(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Http getHttp() {
        return this.http;
    }

    public Swagger getSwagger() {
        return this.swagger;
    }

    public ElapsedTimeLogging getElapsedTimeLogging() {
        return this.elapsedTimeLogging;
    }

    public AopLogging getAopLogging() {
        return this.aopLogging;
    }

    public static class Swagger {
        private boolean enabled;
        private Api api = new Api();
        private OpenApi openApi = new OpenApi();
        private String version;
        private String contactName;
        private String contactEmail;
        private String host;

        public boolean isEnabled() {
            return this.enabled;
        }

        public Api getApi() {
            return this.api;
        }

        public OpenApi getOpenApi() {
            return this.openApi;
        }

        public String getVersion() {
            return this.version;
        }

        public String getContactName() {
            return this.contactName;
        }

        public String getContactEmail() {
            return this.contactEmail;
        }

        public String getHost() {
            return this.host;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setApi(Api api) {
            this.api = api;
        }

        public void setOpenApi(OpenApi openApi) {
            this.openApi = openApi;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setContactName(String contactName) {
            this.contactName = contactName;
        }

        public void setContactEmail(String contactEmail) {
            this.contactEmail = contactEmail;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Swagger)) {
                return false;
            }
            Swagger other = (Swagger)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            Api this$api = this.getApi();
            Api other$api = other.getApi();
            if (this$api == null ? other$api != null : !((Object)this$api).equals(other$api)) {
                return false;
            }
            OpenApi this$openApi = this.getOpenApi();
            OpenApi other$openApi = other.getOpenApi();
            if (this$openApi == null ? other$openApi != null : !((Object)this$openApi).equals(other$openApi)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$contactName = this.getContactName();
            String other$contactName = other.getContactName();
            if (this$contactName == null ? other$contactName != null : !this$contactName.equals(other$contactName)) {
                return false;
            }
            String this$contactEmail = this.getContactEmail();
            String other$contactEmail = other.getContactEmail();
            if (this$contactEmail == null ? other$contactEmail != null : !this$contactEmail.equals(other$contactEmail)) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            return !(this$host == null ? other$host != null : !this$host.equals(other$host));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Swagger;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            Api $api = this.getApi();
            result = result * 59 + ($api == null ? 43 : ((Object)$api).hashCode());
            OpenApi $openApi = this.getOpenApi();
            result = result * 59 + ($openApi == null ? 43 : ((Object)$openApi).hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $contactName = this.getContactName();
            result = result * 59 + ($contactName == null ? 43 : $contactName.hashCode());
            String $contactEmail = this.getContactEmail();
            result = result * 59 + ($contactEmail == null ? 43 : $contactEmail.hashCode());
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            return result;
        }

        public String toString() {
            return "ApplicationProperties.Swagger(enabled=" + this.isEnabled() + ", api=" + this.getApi() + ", openApi=" + this.getOpenApi() + ", version=" + this.getVersion() + ", contactName=" + this.getContactName() + ", contactEmail=" + this.getContactEmail() + ", host=" + this.getHost() + ")";
        }

        public static class OpenApi {
            private String title;
            private String description;

            public String getTitle() {
                return this.title;
            }

            public String getDescription() {
                return this.description;
            }

            public void setTitle(String title) {
                this.title = title;
            }

            public void setDescription(String description) {
                this.description = description;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof OpenApi)) {
                    return false;
                }
                OpenApi other = (OpenApi)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$title = this.getTitle();
                String other$title = other.getTitle();
                if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                    return false;
                }
                String this$description = this.getDescription();
                String other$description = other.getDescription();
                return !(this$description == null ? other$description != null : !this$description.equals(other$description));
            }

            protected boolean canEqual(Object other) {
                return other instanceof OpenApi;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $title = this.getTitle();
                result = result * 59 + ($title == null ? 43 : $title.hashCode());
                String $description = this.getDescription();
                result = result * 59 + ($description == null ? 43 : $description.hashCode());
                return result;
            }

            public String toString() {
                return "ApplicationProperties.Swagger.OpenApi(title=" + this.getTitle() + ", description=" + this.getDescription() + ")";
            }
        }

        public static class Api {
            private String title;
            private String description;

            public String getTitle() {
                return this.title;
            }

            public String getDescription() {
                return this.description;
            }

            public void setTitle(String title) {
                this.title = title;
            }

            public void setDescription(String description) {
                this.description = description;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Api)) {
                    return false;
                }
                Api other = (Api)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$title = this.getTitle();
                String other$title = other.getTitle();
                if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                    return false;
                }
                String this$description = this.getDescription();
                String other$description = other.getDescription();
                return !(this$description == null ? other$description != null : !this$description.equals(other$description));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Api;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $title = this.getTitle();
                result = result * 59 + ($title == null ? 43 : $title.hashCode());
                String $description = this.getDescription();
                result = result * 59 + ($description == null ? 43 : $description.hashCode());
                return result;
            }

            public String toString() {
                return "ApplicationProperties.Swagger.Api(title=" + this.getTitle() + ", description=" + this.getDescription() + ")";
            }
        }
    }

    public static class AopLogging {
        private boolean enabled;
        private boolean methodWhitelistMode;
        private List<String> methodWhitelist;

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isMethodWhitelistMode() {
            return this.methodWhitelistMode;
        }

        public List<String> getMethodWhitelist() {
            return this.methodWhitelist;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setMethodWhitelistMode(boolean methodWhitelistMode) {
            this.methodWhitelistMode = methodWhitelistMode;
        }

        public void setMethodWhitelist(List<String> methodWhitelist) {
            this.methodWhitelist = methodWhitelist;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AopLogging)) {
                return false;
            }
            AopLogging other = (AopLogging)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            if (this.isMethodWhitelistMode() != other.isMethodWhitelistMode()) {
                return false;
            }
            List<String> this$methodWhitelist = this.getMethodWhitelist();
            List<String> other$methodWhitelist = other.getMethodWhitelist();
            return !(this$methodWhitelist == null ? other$methodWhitelist != null : !((Object)this$methodWhitelist).equals(other$methodWhitelist));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AopLogging;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            result = result * 59 + (this.isMethodWhitelistMode() ? 79 : 97);
            List<String> $methodWhitelist = this.getMethodWhitelist();
            result = result * 59 + ($methodWhitelist == null ? 43 : ((Object)$methodWhitelist).hashCode());
            return result;
        }

        public String toString() {
            return "ApplicationProperties.AopLogging(enabled=" + this.isEnabled() + ", methodWhitelistMode=" + this.isMethodWhitelistMode() + ", methodWhitelist=" + this.getMethodWhitelist() + ")";
        }
    }

    public static class ElapsedTimeLogging {
        private boolean enabled;
        private int slowExecutionThreshold;

        public boolean isEnabled() {
            return this.enabled;
        }

        public int getSlowExecutionThreshold() {
            return this.slowExecutionThreshold;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setSlowExecutionThreshold(int slowExecutionThreshold) {
            this.slowExecutionThreshold = slowExecutionThreshold;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ElapsedTimeLogging)) {
                return false;
            }
            ElapsedTimeLogging other = (ElapsedTimeLogging)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            return this.getSlowExecutionThreshold() == other.getSlowExecutionThreshold();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ElapsedTimeLogging;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            result = result * 59 + this.getSlowExecutionThreshold();
            return result;
        }

        public String toString() {
            return "ApplicationProperties.ElapsedTimeLogging(enabled=" + this.isEnabled() + ", slowExecutionThreshold=" + this.getSlowExecutionThreshold() + ")";
        }
    }

    public static class Http {
        private final Cache cache = new Cache();

        public Cache getCache() {
            return this.cache;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Http)) {
                return false;
            }
            Http other = (Http)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Cache this$cache = this.getCache();
            Cache other$cache = other.getCache();
            return !(this$cache == null ? other$cache != null : !((Object)this$cache).equals(other$cache));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Http;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Cache $cache = this.getCache();
            result = result * 59 + ($cache == null ? 43 : ((Object)$cache).hashCode());
            return result;
        }

        public String toString() {
            return "ApplicationProperties.Http(cache=" + this.getCache() + ")";
        }

        public static class Cache {
            private Long timeToLiveInDays = 31L;

            public Long getTimeToLiveInDays() {
                return this.timeToLiveInDays;
            }

            public void setTimeToLiveInDays(Long timeToLiveInDays) {
                this.timeToLiveInDays = timeToLiveInDays;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Cache)) {
                    return false;
                }
                Cache other = (Cache)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$timeToLiveInDays = this.getTimeToLiveInDays();
                Long other$timeToLiveInDays = other.getTimeToLiveInDays();
                return !(this$timeToLiveInDays == null ? other$timeToLiveInDays != null : !((Object)this$timeToLiveInDays).equals(other$timeToLiveInDays));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Cache;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $timeToLiveInDays = this.getTimeToLiveInDays();
                result = result * 59 + ($timeToLiveInDays == null ? 43 : ((Object)$timeToLiveInDays).hashCode());
                return result;
            }

            public String toString() {
                return "ApplicationProperties.Http.Cache(timeToLiveInDays=" + this.getTimeToLiveInDays() + ")";
            }
        }
    }
}

