package com.xforceplus.janus.message.common.config;

import lombok.Data;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

import java.util.List;

/**
 * Properties specific to Application.
 *
 * <p>
 * Properties are configured in the application.yml file.
 * </p>
 *
 * @version 1.0
 * @author: liuyao@xforceplus.com
 * @date: 2020/6/2 10:33
 */
@Slf4j
@Component
@ConfigurationProperties(prefix = "application", ignoreUnknownFields = true)
@Validated
@Getter
public class ApplicationProperties {

    private final ApplicationContext applicationContext;

    public ApplicationProperties(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    private final Swagger            swagger            = new Swagger();
    private final ElapsedTimeLogging elapsedTimeLogging = new ElapsedTimeLogging();
    private final AopLogging         aopLogging         = new AopLogging();
    private final AopAuth            aopAuth            = new AopAuth();

    @Data
    public static class ElapsedTimeLogging {
        private boolean enabled;
        private int     slowExecutionThreshold;
    }

    @Data
    public static class AopLogging {
        private boolean      enabled;
        private boolean      methodWhitelistMode;
        private List<String> methodWhitelist;
    }

    @Data
    public static class AopAuth {
        private boolean enabled;
    }


    @Data
    public static class Swagger {
        private boolean enabled;
        private Api     api     = new Api();
        private OpenApi openApi = new OpenApi();
        private String  version;
        private String  contactName;
        private String  contactEmail;
        private String  host;

        @Data
        public static class Api {
            private String title;
            private String description;
        }

        @Data
        public static class OpenApi {
            private String title;
            private String description;
        }
    }
}
