package com.xforceplus.janus.message.common.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 消息回执对象
 *
 * @author 许传厚@xforceplus.com
 * @date 2021/3/11 2:53 PM
 **/
@ApiModel("消息回执对象")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class MessageAck implements Serializable {

    @ApiModelProperty(value = "回执标记ID", required = true)
    private String receiptHandle;
    @ApiModelProperty(value = "消费tag", required = false)
    private String messageTag;
    @ApiModelProperty(value = "消息来源", required = true)
    private String topicName;
    @ApiModelProperty(value = "消息消费GID", required = true)
    private String groupId;
    @ApiModelProperty(value = "消息ID", example = "消息总线")
    private String messageId;
    @ApiModelProperty(value = "第三方消息ID", example = "RocketMQ,SQS")
    private String thirdPartyId;

    public MessageAck() {

    }

    public MessageAck(String receiptHandle, String topicName, String groupId) {
        this.receiptHandle = receiptHandle;
        this.topicName = topicName;
        this.groupId = groupId;
    }

    public String getConsumerKey() {
        return this.topicName + groupId;
    }

}
