package com.xforceplus.janus.message.common.dto.api;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author zhujie@xforceplus.com
 * @date 2021/1/13 10:29 AM
 **/
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class CacheSubscriptionTagDTO {

    private String id;

    @ApiModelProperty(value = "发布CODE")
    private String pubCode;

    @ApiModelProperty(value = "订阅CODE")
    private String subCode;

    @ApiModelProperty(value = "订阅ID")
    private String subscriptionId;

    @ApiModelProperty(value = "标签来源 0：订阅设置的tag 1：pub设置的tag")
    private String source;

    @ApiModelProperty(value = "发布tag ID")
    private String pubTagId;

    @ApiModelProperty(value = "表 t_filter_rule的主键")
    private String filterRuleId;

    @ApiModelProperty(value = "Tag 可能是 pub那边定义的tag 也可能是 sub这边定义的tag")
    private String tagVal;

    @ApiModelProperty(value = "根据tagRuleId 渲染出来的打标签对象DTO")
    private EventNodeConfigFilterDTO filterDTO;
}
