package com.xforceplus.janus.message.common.dto.api;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 *
 */
@ApiModel("根据渠道模板发送的消息")
@Data
public class SendByChannelTemplateIdDTO extends BaseRequestDTO {

    @ApiModelProperty(value = "渠道代码", required = true, example = "sms")
    private String channelCode;

    @ApiModelProperty(value = "消息内容，格式为字符串", required = true)
    @NotNull
    private String content;

    @ApiModelProperty(value = "订阅者联系方式，如：手机号、用户ID、邮箱等", required = true, example = "liuyao@xforceplus.com")
    private List<String> subscribers;
}
