package com.xforceplus.janus.message.common.dto.api;


import com.xforceplus.janus.message.common.enums.SubTagSourceEnum;

import java.io.Serializable;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class SubTagDto implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID 更新的时候需要")
    private String id;

    @ApiModelProperty(value = "订阅CODE", required = true)
    private String subscriptionCode;

    @ApiModelProperty(value = "发布CODE")
    private String pubCode;

    @ApiModelProperty(value = "发布tagId")
    private String pubTagId;

    /**
     * @see SubTagSourceEnum
     */
    @ApiModelProperty(value = "标签来源 0：订阅设置的tag 1：pub设置的tag")
    private String source;

    @ApiModelProperty(value = "表 t_tag_rule的主键")
    private String tagRuleId;

    @ApiModelProperty(value = "Tag 可能是 pub那边定义的tag 也可能是 sub这边定义的tag")
    private String tagVal;

}
