package com.xforceplus.janus.message.common.enums;

public enum SubMessageStatusEnum {

    WAIT_PROCESS(1, "待处理"),

    PULLED(10, "已拉取，等待消费确认"),

    HAD_CONSUMER(20, "已消费"),

    DELETED(0, "删除");

    private Integer code;

    private String desc;

    SubMessageStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static SubMessageStatusEnum getByCode(Integer code) {
        for (SubMessageStatusEnum i : values()) {
            if (i.getCode().equals(code)) {
                return i;
            }
        }
        throw new IllegalArgumentException("消息状态没找到");
    }
}
