package com.xforceplus.janus.message.common.enums;

public enum SubTagSourceEnum {

    PUB("1", "发布"),

    SUB("0", "订阅"),

    ;

    private String code;

    private String desc;

    SubTagSourceEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static SubTagSourceEnum getByCode(String code) {
        for (SubTagSourceEnum i : values()) {
            if (i.getCode().equals(code)) {
                return i;
            }
        }
        throw new IllegalArgumentException("订阅的tag类型没找到");
    }
}
