package com.xforceplus.janus.message.common.utils;

import java.util.concurrent.*;

public class ThreadPoolUtils {

    private static final ThreadPoolExecutor EXECUTOR = new ThreadPoolExecutor(8, 16, 60, TimeUnit.SECONDS, new LinkedBlockingDeque<>(128));

    public static void execute(Runnable runnable) {
        EXECUTOR.execute(runnable);
    }

    public static <T> Future<T> submit(Callable<T> runnable) {
        return EXECUTOR.submit(runnable);
    }

}
