/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.message.common.utils;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JwtUtils {
    private static final Logger log = LoggerFactory.getLogger(JwtUtils.class);
    public static final String HEADER_MB_TOKEN_NAME = "MB_TOKEN";
    public static final long EXPIRED_TIME = TimeUnit.DAYS.toMillis(18250L);
    public static final String SIGN_KEY = "ukc8BDbRigUDaY6pZFfWus2jZWLPHO17L8s";

    public static String generateJwtToken(String env, String appKey, String appSecret) {
        return Jwts.builder().setHeaderParam("typ", (Object)"JWT").setHeaderParam("alg", (Object)"HS256").setSubject("message-bus").setIssuedAt(new Date()).setExpiration(new Date(System.currentTimeMillis() + EXPIRED_TIME)).claim("env", (Object)env).claim("appKey", (Object)appKey).claim("appSecret", (Object)appSecret).signWith(SignatureAlgorithm.HS256, SIGN_KEY).compact();
    }

    public static String getAppKeyFromJwtToken(String jwtToken) {
        if (StringUtils.isEmpty((CharSequence)jwtToken)) {
            return "";
        }
        try {
            Jws claimsJws = Jwts.parser().setSigningKey(SIGN_KEY).parseClaimsJws(jwtToken);
            Claims claims = (Claims)claimsJws.getBody();
            return (String)claims.get((Object)"appKey");
        }
        catch (Exception e) {
            log.error("Failed to get app key from JWT token!", (Throwable)e);
            return "";
        }
    }

    public static String getEnvFromJwtToken(String jwtToken) {
        if (StringUtils.isEmpty((CharSequence)jwtToken)) {
            return "";
        }
        try {
            Jws claimsJws = Jwts.parser().setSigningKey(SIGN_KEY).parseClaimsJws(jwtToken);
            Claims claims = (Claims)claimsJws.getBody();
            return (String)claims.get((Object)"env");
        }
        catch (Exception e) {
            log.error("Failed to get app key from JWT token!", (Throwable)e);
            return "";
        }
    }
}

