package com.xforceplus.janus.message.common.enums;

public enum MQTypeEnum {

    ALI_ROCKET_MQ("ALI_ROCKET_MQ", "阿里云的ROCKET_MQ"),

    SELF_ROCKET_MQ("SELF_ROCKET_MQ", "自建的ROCKET_MQ"),

    SELF_KAFKA("SELF_KAFKA", "自建的KAFKA"),

    AWS_SQS("AWS_SQS", "亚马逊SQS");

    private String code;

    private String desc;

    MQTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static MQTypeEnum getByCode(Integer code) {
        for (MQTypeEnum i : values()) {
            if (i.getCode().equals(code)) {
                return i;
            }
        }
        throw new IllegalArgumentException("模板类型没找到");
    }
}
