package com.xforceplus.janus.message.common.dto.admin;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author zhujie@xforceplus.com
 * @date 2021/4/22 10:58 AM
 **/
@Data
public class MessageReplayTaskAddDTO {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "pubAppKey")
    @NotBlank(message="pubAppKey并不能为空")
    private String pubAppKey;

    @ApiModelProperty(value = "pubCode")
    @NotBlank(message="pubCode并不能为空")
    private String pubCode;

    @ApiModelProperty(value = "subAppKey")
    private String subAppKey;

    @ApiModelProperty(value = "消息发送的开始时间")
    @NotNull(message = "消息发送的开始时间不能为空")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    @ApiModelProperty(value = "消息发送的结束时间")
    @NotNull(message = "消息发送的结束时间不能为空")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    @ApiModelProperty(value = "任务类型 10回放 11补单")
    private Integer type;

}
