package com.xforceplus.janus.message.common.dto.query;

import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 消息轨迹查询DTO
 *
 * @author zhujie@xforceplus.com
 * @date 2021/2/18 9:36 AM
 **/
@Data
public class QMessageTraceDTO {

    @ApiModelProperty(value = "MB的消息ID")
    private Long messageId;

    @ApiModelProperty(value = "消息ID")
    private String thirdMessageId;

    @ApiModelProperty(value = "订阅者appKey")
    private String subAppKey;

    @ApiModelProperty(value = "开始时间 yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss", iso = DateTimeFormat.ISO.DATE_TIME)
    private Date start;

    @ApiModelProperty(value = "结束时间 yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss", iso = DateTimeFormat.ISO.DATE_TIME)
    private Date end;
}
