package com.xforceplus.janus.message.common.enums;

import java.util.ArrayList;
import java.util.List;

public enum NodeTypeEnum {

    SENSITIVE_WORD("SENSITIVE_WORD", "敏感词"),

    FILTER("FILTER", "过滤"),

    TAG("TAG", "打标签"),

    TRANSFORMATION("TRANSFORMATION", "数据转换"),

    SMS("SMS", "短信"),

    EMAIL("EMAIL", "邮箱"),
    ;

    private String code;

    private String desc;

    NodeTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static List<String> getDataProcess() {
        List<String> types = new ArrayList<>();
        types.add(SENSITIVE_WORD.code);
        types.add(FILTER.code);
        types.add(TAG.code);
        types.add(TRANSFORMATION.code);

        return types;
    }


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static NodeTypeEnum getByCode(String code) {
        for (NodeTypeEnum i : values()) {
            if (i.getCode().equals(code)) {
                return i;
            }
        }
        throw new IllegalArgumentException("节点类型没找到");
    }
}
