package com.xforceplus.janus.message.common.utils.kryo;

import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class KryoRedisSerializer<T> implements RedisSerializer<T> {

    @Override
    public byte[] serialize(Object obj) throws SerializationException {
        return KryoSerializer.getInstance().serialize(obj);
    }

    @Override
    public T deserialize(byte[] bytes) throws SerializationException {
        return KryoSerializer.getInstance().deserialize(bytes);
    }
}
