package com.xforceplus.janus.message.common.dto;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;


import lombok.Data;

/**
 * @author zhujie@xforceplus.com
 * @date 2021/2/18 9:47 AM
 **/
@Data
public class QueryPage<T> {

    /**
     * 当前页码
     */
    private Long page;

    /**
     * 每页显示记录数
     */
    private Long limit;

    /**
     * 排序字段
     */
    private String sidx;

    /**
     * 排序方式
     */
    private String order;

    /**
     * 升序
     */
    private boolean asc;

    public IPage<T> getPageDTO() {
        //分页参数
        long curPage = 1;
        long limit = 10;

        if (getPage() != null) {
            curPage = getPage();
        }
        if (getLimit() != null) {
            limit = getLimit();
        }

        //分页对象
        Page<T> page = new Page<>(curPage, limit);

        //分页参数
//        params.put(PageConstant.PAGE, page);

        //排序字段
        //防止SQL注入（因为sidx、order是通过拼接SQL实现排序的，会有SQL注入风险）
//        String orderField = SQLFilter.sqlInject(getSidx());
//        String order = getOrder();
//
//        //前端字段排序
//        if (StringUtils.isNotEmpty(orderField) && StringUtils.isNotEmpty(order)) {
//            if (PageConstant.ASC.equalsIgnoreCase(order)) {
//                return page.setAsc(orderField);
//            } else {
//                return page.setDesc(orderField);
//            }
//        }

        return page;
    }
}
