package com.xforceplus.janus.message.common.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.Map;

/**
 * 请求消息
 *
 * @author zhujie@xforceplus.com
 * @date 2021/3/3 2:53 PM
 **/
@ApiModel("请求消息")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class RequestMessage implements Serializable {

    @ApiModelProperty(value = "唯一ID，用于幂等处理", required = false)
    private String uniqueId;

    @ApiModelProperty(value = "消息内容", required = true, notes = "格式为字符串")
    @NotEmpty
    private String content;

    @ApiModelProperty(value = "消息属性Map", required = false)
    private Map<String, String> properties;

    @ApiModelProperty(value = "发送时间戳，用来记录生产者发送消息时间点", required = false, example = "1614930380000")
    private long sentTime;
}
