package com.xforceplus.janus.message.common.dto.api;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.janus.shooter.core.entity.TagFilter;

import java.util.List;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author zhujie@xforceplus.com
 * @date 2021/1/13 10:29 AM
 **/
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class CacheSubscriptionTagDTO {

    private String id;

    @ApiModelProperty(value = "发布CODE")
    private String pubCode;

    @ApiModelProperty(value = "发布appKey")
    private String pubAppKey;

    @ApiModelProperty(value = "订阅appKey")
    private String subAppKey;

    @ApiModelProperty(value = "表 t_filter_rule的主键")
    private String filterRuleId;

    @ApiModelProperty(value = "内容过滤")
    private List<TagFilter> contentFilters;

    @ApiModelProperty(value = "属性过滤")
    private List<TagFilter> propFilters;
}
