package com.xforceplus.janus.message.common.enums;

public enum MessageTraceStatusEnum {

    PUSHED(1, "已上传，待拉取"),

    PULLED(10, "已拉取，等待消费确认"),

    PULLED_FORMATE_ERROR(11, "已拉取，格式错误"),

    PULLED_ERROR(12, "已拉取，错误"),

    UN_PUSHED_FILTERED(15, "未上传，被过滤"),

    CONSUMED(20, "已消费"),

    CALLBACK_PROCESSED_FAILED(21, "回调处理失败"),

    CALLBACK_SENT_FAILED(22, "回调发送失败"),

    DELETED(0, "删除"),

    SMS_SENT(51, "短信发送成功"),

    SMS_PROCESSED_FAILED(52, "短信处理失败"),

    SMS_SENT_FAILED(53, "短信发送失败"),

    EMAIL_SENT(56, "短信发送成功"),

    EMAIL_PROCESSED_FAILED(57, "短信处理失败"),

    EMAIL_SENT_FAILED(58, "短信发送失败"),

    REST_SENT(61, "REST发送成功"),

    REST_PROCESSED_FAILED(62, "REST处理失败"),

    REST_SENT_FAILED(63, "REST发送失败");

    private Integer code;

    private String desc;

    MessageTraceStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static MessageTraceStatusEnum getByCode(Integer code) {
        for (MessageTraceStatusEnum i : values()) {
            if (i.getCode().equals(code)) {
                return i;
            }
        }
        throw new IllegalArgumentException("消息状态没找到");
    }
}
