package com.xforceplus.janus.message.common.utils;


import org.springframework.cglib.beans.BeanCopier;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Bean 工具类
 */
public class XBeanUtils<S, T> {

    public static Map<String, BeanCopier> beanCopierMap = new ConcurrentHashMap<>();

    /**
     * 转换单个实体
     */
    public static <S, T> T copyBean(S source, Class<T> modelClass) throws IllegalAccessException, InstantiationException {
        if (source == null) {
            return null;
        }
        String beanKey = generateKey(source.getClass(), modelClass);
        BeanCopier copier = null;
        if (!beanCopierMap.containsKey(beanKey)) {
            copier = BeanCopier.create(source.getClass(), modelClass, false);
            beanCopierMap.put(beanKey, copier);
        } else {
            copier = beanCopierMap.get(beanKey);
        }
        Object model = modelClass.newInstance();
        copier.copy(source, model, null);
        return (T) model;
    }

    public static <S, T> T copyBeanNoException(S source, Class<T> modelClass) {
        Object model = null;
        try {
            model = copyBean(source, modelClass);
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InstantiationException e) {
            e.printStackTrace();
        }
        return (T) model;
    }


    /**
     * List集合对象转换
     */
    public static <F, T> List<T> copyListBean(List<F> fromList, Class<T> tClass) throws InstantiationException, IllegalAccessException {
        if (fromList.isEmpty() || fromList == null) {
            return null;
        }
        List<T> tList = new ArrayList<>();
        for (F f : fromList) {
            T t = copyBean(f, tClass);
            tList.add(t);
        }
        return tList;
    }


    private static String generateKey(Class<?> class1, Class<?> class2) {
        return class1.toString() + class2.toString();
    }

}

