package com.xforceplus.janus.message.common.utils;


import java.util.ArrayList;
import java.util.List;

import lombok.NonNull;

/**
 * @author zhujie@xforceplus.com
 * @date 2021/1/29 10:31 AM
 **/
public class XListUtils<T> {

    public List<List<T>> split(@NonNull List<T> objects, int splitSize) {
        List<List<T>> result = new ArrayList<>();
        if (objects.size() <= splitSize) {
            result.add(objects);
            return result;
        } else {
            int page = objects.size() % splitSize;
            for (int i = 0; i < page; i++) {
                int start = i * splitSize;
                int end = (i + 1) * splitSize;
                if (end > objects.size()) {
                    end = objects.size();
                }
                result.add(objects.subList(start, end));
            }
            return result;
        }
    }
}
