package com.xforceplus.janus.message.common.enums;

public enum DelayMessageStatusEnum {

    WAIT_SEND(0, "待发送"),

    SENDING(1, "发送中"),

    OVER(2, "已发送");

    private Integer code;

    private String desc;

    DelayMessageStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static DelayMessageStatusEnum getByCode(Integer code) {
        for (DelayMessageStatusEnum i : values()) {
            if (i.getCode().equals(code)) {
                return i;
            }
        }
        throw new IllegalArgumentException("消息状态没找到");
    }
}
