/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.message.common.config;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Component
@ConfigurationProperties(prefix="application")
@Validated
public class ApplicationProperties {
    private static final Logger log = LoggerFactory.getLogger(ApplicationProperties.class);
    private final Swagger swagger = new Swagger();
    private final AopLogging aopLogging = new AopLogging();
    private final AopAuth aopAuth = new AopAuth();
    private final RateLimit rateLimit = new RateLimit();
    private final RefreshCacheHistory refreshCacheHistory = new RefreshCacheHistory();
    private final HttpClient httpClient = new HttpClient();
    private final AppTenant appTenant = new AppTenant();

    public Swagger getSwagger() {
        return this.swagger;
    }

    public AopLogging getAopLogging() {
        return this.aopLogging;
    }

    public AopAuth getAopAuth() {
        return this.aopAuth;
    }

    public RateLimit getRateLimit() {
        return this.rateLimit;
    }

    public RefreshCacheHistory getRefreshCacheHistory() {
        return this.refreshCacheHistory;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public AppTenant getAppTenant() {
        return this.appTenant;
    }

    public static class AppTenant {
        private long emailAppId;
        private long emailTenantId = 0L;
        private long smsAppId;
        private long smsTenantId = 0L;

        public long getEmailAppId() {
            return this.emailAppId;
        }

        public long getEmailTenantId() {
            return this.emailTenantId;
        }

        public long getSmsAppId() {
            return this.smsAppId;
        }

        public long getSmsTenantId() {
            return this.smsTenantId;
        }

        public void setEmailAppId(long emailAppId) {
            this.emailAppId = emailAppId;
        }

        public void setEmailTenantId(long emailTenantId) {
            this.emailTenantId = emailTenantId;
        }

        public void setSmsAppId(long smsAppId) {
            this.smsAppId = smsAppId;
        }

        public void setSmsTenantId(long smsTenantId) {
            this.smsTenantId = smsTenantId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AppTenant)) {
                return false;
            }
            AppTenant other = (AppTenant)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getEmailAppId() != other.getEmailAppId()) {
                return false;
            }
            if (this.getEmailTenantId() != other.getEmailTenantId()) {
                return false;
            }
            if (this.getSmsAppId() != other.getSmsAppId()) {
                return false;
            }
            return this.getSmsTenantId() == other.getSmsTenantId();
        }

        protected boolean canEqual(Object other) {
            return other instanceof AppTenant;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $emailAppId = this.getEmailAppId();
            result = result * 59 + (int)($emailAppId >>> 32 ^ $emailAppId);
            long $emailTenantId = this.getEmailTenantId();
            result = result * 59 + (int)($emailTenantId >>> 32 ^ $emailTenantId);
            long $smsAppId = this.getSmsAppId();
            result = result * 59 + (int)($smsAppId >>> 32 ^ $smsAppId);
            long $smsTenantId = this.getSmsTenantId();
            result = result * 59 + (int)($smsTenantId >>> 32 ^ $smsTenantId);
            return result;
        }

        public String toString() {
            return "ApplicationProperties.AppTenant(emailAppId=" + this.getEmailAppId() + ", emailTenantId=" + this.getEmailTenantId() + ", smsAppId=" + this.getSmsAppId() + ", smsTenantId=" + this.getSmsTenantId() + ")";
        }
    }

    public static class HttpClient {
        private int readTimeout;
        private int retryCount;
        private boolean enableLogRequest;
        private boolean enableLogResponseStatus;
        private boolean enableLogResponseBody;

        public int getReadTimeout() {
            return this.readTimeout;
        }

        public int getRetryCount() {
            return this.retryCount;
        }

        public boolean isEnableLogRequest() {
            return this.enableLogRequest;
        }

        public boolean isEnableLogResponseStatus() {
            return this.enableLogResponseStatus;
        }

        public boolean isEnableLogResponseBody() {
            return this.enableLogResponseBody;
        }

        public void setReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
        }

        public void setRetryCount(int retryCount) {
            this.retryCount = retryCount;
        }

        public void setEnableLogRequest(boolean enableLogRequest) {
            this.enableLogRequest = enableLogRequest;
        }

        public void setEnableLogResponseStatus(boolean enableLogResponseStatus) {
            this.enableLogResponseStatus = enableLogResponseStatus;
        }

        public void setEnableLogResponseBody(boolean enableLogResponseBody) {
            this.enableLogResponseBody = enableLogResponseBody;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HttpClient)) {
                return false;
            }
            HttpClient other = (HttpClient)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getReadTimeout() != other.getReadTimeout()) {
                return false;
            }
            if (this.getRetryCount() != other.getRetryCount()) {
                return false;
            }
            if (this.isEnableLogRequest() != other.isEnableLogRequest()) {
                return false;
            }
            if (this.isEnableLogResponseStatus() != other.isEnableLogResponseStatus()) {
                return false;
            }
            return this.isEnableLogResponseBody() == other.isEnableLogResponseBody();
        }

        protected boolean canEqual(Object other) {
            return other instanceof HttpClient;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getReadTimeout();
            result = result * 59 + this.getRetryCount();
            result = result * 59 + (this.isEnableLogRequest() ? 79 : 97);
            result = result * 59 + (this.isEnableLogResponseStatus() ? 79 : 97);
            result = result * 59 + (this.isEnableLogResponseBody() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "ApplicationProperties.HttpClient(readTimeout=" + this.getReadTimeout() + ", retryCount=" + this.getRetryCount() + ", enableLogRequest=" + this.isEnableLogRequest() + ", enableLogResponseStatus=" + this.isEnableLogResponseStatus() + ", enableLogResponseBody=" + this.isEnableLogResponseBody() + ")";
        }
    }

    public static class RefreshCacheHistory {
        private boolean enabled;
        private int maxRecords;

        public boolean isEnabled() {
            return this.enabled;
        }

        public int getMaxRecords() {
            return this.maxRecords;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setMaxRecords(int maxRecords) {
            this.maxRecords = maxRecords;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RefreshCacheHistory)) {
                return false;
            }
            RefreshCacheHistory other = (RefreshCacheHistory)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            return this.getMaxRecords() == other.getMaxRecords();
        }

        protected boolean canEqual(Object other) {
            return other instanceof RefreshCacheHistory;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            result = result * 59 + this.getMaxRecords();
            return result;
        }

        public String toString() {
            return "ApplicationProperties.RefreshCacheHistory(enabled=" + this.isEnabled() + ", maxRecords=" + this.getMaxRecords() + ")";
        }
    }

    public static class RateLimit {
        private boolean enabled;
        private String name;
        private long permitsPerSecond;

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getName() {
            return this.name;
        }

        public long getPermitsPerSecond() {
            return this.permitsPerSecond;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setPermitsPerSecond(long permitsPerSecond) {
            this.permitsPerSecond = permitsPerSecond;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RateLimit)) {
                return false;
            }
            RateLimit other = (RateLimit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            return this.getPermitsPerSecond() == other.getPermitsPerSecond();
        }

        protected boolean canEqual(Object other) {
            return other instanceof RateLimit;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            long $permitsPerSecond = this.getPermitsPerSecond();
            result = result * 59 + (int)($permitsPerSecond >>> 32 ^ $permitsPerSecond);
            return result;
        }

        public String toString() {
            return "ApplicationProperties.RateLimit(enabled=" + this.isEnabled() + ", name=" + this.getName() + ", permitsPerSecond=" + this.getPermitsPerSecond() + ")";
        }
    }

    public static class AopAuth {
        private boolean enabled;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AopAuth)) {
                return false;
            }
            AopAuth other = (AopAuth)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isEnabled() == other.isEnabled();
        }

        protected boolean canEqual(Object other) {
            return other instanceof AopAuth;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "ApplicationProperties.AopAuth(enabled=" + this.isEnabled() + ")";
        }
    }

    public static class AopLogging {
        private boolean enabled;
        private boolean methodWhitelistMode;
        private List<String> methodWhitelist;

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isMethodWhitelistMode() {
            return this.methodWhitelistMode;
        }

        public List<String> getMethodWhitelist() {
            return this.methodWhitelist;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setMethodWhitelistMode(boolean methodWhitelistMode) {
            this.methodWhitelistMode = methodWhitelistMode;
        }

        public void setMethodWhitelist(List<String> methodWhitelist) {
            this.methodWhitelist = methodWhitelist;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AopLogging)) {
                return false;
            }
            AopLogging other = (AopLogging)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            if (this.isMethodWhitelistMode() != other.isMethodWhitelistMode()) {
                return false;
            }
            List<String> this$methodWhitelist = this.getMethodWhitelist();
            List<String> other$methodWhitelist = other.getMethodWhitelist();
            return !(this$methodWhitelist == null ? other$methodWhitelist != null : !((Object)this$methodWhitelist).equals(other$methodWhitelist));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AopLogging;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            result = result * 59 + (this.isMethodWhitelistMode() ? 79 : 97);
            List<String> $methodWhitelist = this.getMethodWhitelist();
            result = result * 59 + ($methodWhitelist == null ? 43 : ((Object)$methodWhitelist).hashCode());
            return result;
        }

        public String toString() {
            return "ApplicationProperties.AopLogging(enabled=" + this.isEnabled() + ", methodWhitelistMode=" + this.isMethodWhitelistMode() + ", methodWhitelist=" + this.getMethodWhitelist() + ")";
        }
    }

    public static class Swagger {
        private boolean enabled;
        private Api api = new Api();
        private OpenApi openApi = new OpenApi();
        private String version;
        private String contactName;
        private String contactEmail;
        private String host;

        public boolean isEnabled() {
            return this.enabled;
        }

        public Api getApi() {
            return this.api;
        }

        public OpenApi getOpenApi() {
            return this.openApi;
        }

        public String getVersion() {
            return this.version;
        }

        public String getContactName() {
            return this.contactName;
        }

        public String getContactEmail() {
            return this.contactEmail;
        }

        public String getHost() {
            return this.host;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setApi(Api api) {
            this.api = api;
        }

        public void setOpenApi(OpenApi openApi) {
            this.openApi = openApi;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setContactName(String contactName) {
            this.contactName = contactName;
        }

        public void setContactEmail(String contactEmail) {
            this.contactEmail = contactEmail;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Swagger)) {
                return false;
            }
            Swagger other = (Swagger)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            Api this$api = this.getApi();
            Api other$api = other.getApi();
            if (this$api == null ? other$api != null : !((Object)this$api).equals(other$api)) {
                return false;
            }
            OpenApi this$openApi = this.getOpenApi();
            OpenApi other$openApi = other.getOpenApi();
            if (this$openApi == null ? other$openApi != null : !((Object)this$openApi).equals(other$openApi)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$contactName = this.getContactName();
            String other$contactName = other.getContactName();
            if (this$contactName == null ? other$contactName != null : !this$contactName.equals(other$contactName)) {
                return false;
            }
            String this$contactEmail = this.getContactEmail();
            String other$contactEmail = other.getContactEmail();
            if (this$contactEmail == null ? other$contactEmail != null : !this$contactEmail.equals(other$contactEmail)) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            return !(this$host == null ? other$host != null : !this$host.equals(other$host));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Swagger;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            Api $api = this.getApi();
            result = result * 59 + ($api == null ? 43 : ((Object)$api).hashCode());
            OpenApi $openApi = this.getOpenApi();
            result = result * 59 + ($openApi == null ? 43 : ((Object)$openApi).hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $contactName = this.getContactName();
            result = result * 59 + ($contactName == null ? 43 : $contactName.hashCode());
            String $contactEmail = this.getContactEmail();
            result = result * 59 + ($contactEmail == null ? 43 : $contactEmail.hashCode());
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            return result;
        }

        public String toString() {
            return "ApplicationProperties.Swagger(enabled=" + this.isEnabled() + ", api=" + this.getApi() + ", openApi=" + this.getOpenApi() + ", version=" + this.getVersion() + ", contactName=" + this.getContactName() + ", contactEmail=" + this.getContactEmail() + ", host=" + this.getHost() + ")";
        }

        public static class OpenApi {
            private String title;
            private String description;

            public String getTitle() {
                return this.title;
            }

            public String getDescription() {
                return this.description;
            }

            public void setTitle(String title) {
                this.title = title;
            }

            public void setDescription(String description) {
                this.description = description;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof OpenApi)) {
                    return false;
                }
                OpenApi other = (OpenApi)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$title = this.getTitle();
                String other$title = other.getTitle();
                if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                    return false;
                }
                String this$description = this.getDescription();
                String other$description = other.getDescription();
                return !(this$description == null ? other$description != null : !this$description.equals(other$description));
            }

            protected boolean canEqual(Object other) {
                return other instanceof OpenApi;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $title = this.getTitle();
                result = result * 59 + ($title == null ? 43 : $title.hashCode());
                String $description = this.getDescription();
                result = result * 59 + ($description == null ? 43 : $description.hashCode());
                return result;
            }

            public String toString() {
                return "ApplicationProperties.Swagger.OpenApi(title=" + this.getTitle() + ", description=" + this.getDescription() + ")";
            }
        }

        public static class Api {
            private String title;
            private String description;

            public String getTitle() {
                return this.title;
            }

            public String getDescription() {
                return this.description;
            }

            public void setTitle(String title) {
                this.title = title;
            }

            public void setDescription(String description) {
                this.description = description;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Api)) {
                    return false;
                }
                Api other = (Api)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$title = this.getTitle();
                String other$title = other.getTitle();
                if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                    return false;
                }
                String this$description = this.getDescription();
                String other$description = other.getDescription();
                return !(this$description == null ? other$description != null : !this$description.equals(other$description));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Api;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $title = this.getTitle();
                result = result * 59 + ($title == null ? 43 : $title.hashCode());
                String $description = this.getDescription();
                result = result * 59 + ($description == null ? 43 : $description.hashCode());
                return result;
            }

            public String toString() {
                return "ApplicationProperties.Swagger.Api(title=" + this.getTitle() + ", description=" + this.getDescription() + ")";
            }
        }
    }
}

