package com.xforceplus.janus.message.common.dto.api;

import javax.validation.constraints.NotBlank;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @program: message-center->EventEditDTO
 * @description:
 * @author: xuchuanhou
 * @create: 2021-02-08 17:40
 **/
@Data
public class EventNodeSendAddDTO {

    private String id;

    @NotBlank(message = "事件ID不能为空")
    @ApiModelProperty(value = "事件ID",required = true)
    private String eventId;

    @ApiModelProperty(value = "Cron")
    private String cron;

    @ApiModelProperty(value = "延时的时间")
    private Integer delayTime;

    @ApiModelProperty(value = "延期时间类型 时分秒")
    private String delayTimeType;

    @ApiModelProperty(value = "节点类型：数据处理【FILTER:过滤、TAG:打标签】发送设置【TASK:定时、DELAY：延时】等等",required = true)
    private String type;

}
