package com.xforceplus.janus.message.common.enums;

public enum AliyunSmsTemplateTypeEnum {

    VERIFICATION_CODE(0, "验证码"),

    SMS_NOTICE(1, "短信通知"),

    PROMOTE_SMS(2, "推广短信"),

    INTERNATIONAL_SMS(3, "国际/港澳台消息");

    private Integer code;

    private String desc;

    AliyunSmsTemplateTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static AliyunSmsTemplateTypeEnum getByCode(Integer code) {
        for (AliyunSmsTemplateTypeEnum i : values()) {
            if (i.getCode().equals(code)) {
                return i;
            }
        }
        throw new IllegalArgumentException("模板类型没找到");
    }
}
