package com.xforceplus.janus.message.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum AppTypeEnum {

    APP("APP", "正常应用"),

    SMS("SMS", "短信"),

    EMAIL("EMAIL", "邮件"),

    REST("REST", "REST提供方");

    private String code;

    private String desc;

    AppTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static AppTypeEnum getByCode(String code) {
        for (AppTypeEnum i : values()) {
            if (i.getCode().equalsIgnoreCase(code)) {
                return i;
            }
        }
        throw new IllegalArgumentException("应用类型没找到");
    }

    public static Map<String, String> getAll() {
        Map<String, String> map = new HashMap<>();
        for (AppTypeEnum i : values()) {
            map.put(i.getCode(), i.getDesc());
        }
        return map;
    }

    public static Map<String, String> channelAndCallbacks() {
        Map<String, String> map = new HashMap<>();
        for (AppTypeEnum i : values()) {
            if (!i.getCode().equals(APP.getCode())) {
                map.put(i.getCode(), i.getDesc());
            }
        }
        return map;
    }
}
