package com.xforceplus.janus.message.common.dto.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import org.springframework.scheduling.support.CronSequenceGenerator;

import java.beans.Transient;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 事件消息分发-定时
 *
 * @author zhujie@xforceplus.com
 * @date 2021/1/26 10:37 AM
 **/
@Data
public class EventNodeConfigTimedDTO implements Serializable {

    @ApiModelProperty(value = "cron 表达式")
    private String cron;

    @JsonIgnoreProperties(ignoreUnknown = true)
    private long nextExecuteTime;

    public long getNextExecuteTime() {
        CronSequenceGenerator cronSequenceGenerator = new CronSequenceGenerator(getCron());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List<String> list = new ArrayList<>(20);
        Date nextTimePoint = cronSequenceGenerator.next(new Date());
        return nextTimePoint.getTime();
    }
}
