/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.message.common.utils;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class MethodParameterUtils {
    public static final String PARAM_TYPE_STR_DELIMITER = ",";
    public static final String VOID = "void";
    private static final String ARRAY_TYPE_SUFFIX = "[]";
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final String[] PRIMITIVE_TYPES = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short", "void"};
    private static final Class<?>[] PRIMITIVE_CLASSES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE};
    private static final int PRIMITIVE_CLASS_NAME_MAX_LENGTH = 7;
    private static final int MAX_NEST_DEPTH = 2;
    private static final Map<String, Class<?>> NAME_TO_CLASS_MAP = new ConcurrentHashMap();
    private static final Map<Class<?>, String> CLASS_TO_NAME_MAP = new ConcurrentHashMap();

    public static String getMethodParameters(Method method) {
        if (ArrayUtils.isEmpty((Object[])method.getParameterTypes())) {
            return VOID;
        }
        return Arrays.stream(method.getParameterTypes()).map(MethodParameterUtils::getClassName).collect(Collectors.joining(PARAM_TYPE_STR_DELIMITER));
    }

    public static String getMethodSignature(Method method) {
        return MethodParameterUtils.getMethodSignature(method.getName(), MethodParameterUtils.getMethodParameters(method));
    }

    public static String getMethodSignature(String methodName, String methodParameters) {
        if (StringUtils.isEmpty((CharSequence)methodParameters)) {
            return methodName + "(" + VOID + ")";
        }
        return methodName + "(" + methodParameters + ")";
    }

    public static Class<?>[] forNames(String classNameList) throws ClassNotFoundException {
        if (StringUtils.isEmpty((CharSequence)classNameList) || VOID.equals(classNameList)) {
            return EMPTY_CLASS_ARRAY;
        }
        String[] classNames = classNameList.split(PARAM_TYPE_STR_DELIMITER);
        Class[] classTypes = new Class[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            classTypes[i] = MethodParameterUtils.forName(classNames[i]);
        }
        return classTypes;
    }

    public static Class<?> forName(String className) throws ClassNotFoundException {
        if (StringUtils.isEmpty((CharSequence)className)) {
            return null;
        }
        Class<?> clz = NAME_TO_CLASS_MAP.get(className);
        if (clz != null) {
            return clz;
        }
        clz = MethodParameterUtils.doForName(className);
        NAME_TO_CLASS_MAP.putIfAbsent(className, clz);
        return clz;
    }

    private static Class<?> doForName(String className) throws ClassNotFoundException {
        if (!className.endsWith(ARRAY_TYPE_SUFFIX)) {
            Class<?> clz = MethodParameterUtils.getPrimitiveTypeClass(className);
            if (clz != null) {
                return clz;
            }
            return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        int dimensionSize = 0;
        while (className.endsWith(ARRAY_TYPE_SUFFIX)) {
            ++dimensionSize;
            className = className.substring(0, className.length() - 2);
        }
        int[] dimensions = new int[dimensionSize];
        Class<?> clz = MethodParameterUtils.getPrimitiveTypeClass(className);
        if (clz == null) {
            clz = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        return Array.newInstance(clz, dimensions).getClass();
    }

    public static Class<?> getPrimitiveTypeClass(String className) {
        if (className.length() > 7) {
            return null;
        }
        int index = Arrays.binarySearch(PRIMITIVE_TYPES, className);
        if (index < 0) {
            return null;
        }
        return PRIMITIVE_CLASSES[index];
    }

    public static String getClassName(Class<?> clz) {
        if (clz == null) {
            return null;
        }
        String className = CLASS_TO_NAME_MAP.get(clz);
        if (className != null) {
            return className;
        }
        className = MethodParameterUtils.doGetClassName(clz);
        CLASS_TO_NAME_MAP.putIfAbsent(clz, className);
        return className;
    }

    private static String doGetClassName(Class<?> clz) {
        if (!clz.isArray()) {
            return clz.getName();
        }
        StringBuilder sb = new StringBuilder();
        while (clz.isArray()) {
            sb.append(ARRAY_TYPE_SUFFIX);
            clz = clz.getComponentType();
        }
        return clz.getName() + sb.toString();
    }

    public static List<Method> getPublicMethod(Class<?> clz) {
        return Arrays.stream(clz.getMethods()).filter(method -> Modifier.isPublic(method.getModifiers()) && method.getDeclaringClass() != Object.class).collect(Collectors.toList());
    }

    public static Object getEmptyObject(Class<?> type) {
        return MethodParameterUtils.getEmptyObject(type, new HashMap(1), 0);
    }

    private static Object getEmptyObject(Class<?> type, Map<Class<?>, Object> emptyInstances, int nestDepth) {
        if (nestDepth > 2) {
            return null;
        }
        if (type == null) {
            return null;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return false;
        }
        if (type == Character.TYPE || type == Character.class) {
            return Character.valueOf('\u0000');
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return (byte)0;
        }
        if (type == Short.TYPE || type == Short.class) {
            return (short)0;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return 0;
        }
        if (type == Long.TYPE || type == Long.class) {
            return 0L;
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(0.0f);
        }
        if (type == Double.TYPE || type == Double.class) {
            return 0.0;
        }
        if (type.isArray()) {
            return Array.newInstance(type.getComponentType(), 0);
        }
        if (type.isAssignableFrom(ArrayList.class)) {
            return new ArrayList(0);
        }
        if (type.isAssignableFrom(HashSet.class)) {
            return new HashSet(0);
        }
        if (type.isAssignableFrom(HashMap.class)) {
            return new HashMap(0);
        }
        if (String.class.equals(type)) {
            return "";
        }
        if (!type.isInterface()) {
            try {
                Object value = emptyInstances.get(type);
                if (value == null) {
                    value = type.newInstance();
                    emptyInstances.put(type, value);
                }
                for (Class<?> cls = value.getClass(); cls != null && cls != Object.class; cls = cls.getSuperclass()) {
                    Field[] fields;
                    for (Field field : fields = cls.getDeclaredFields()) {
                        Object property = MethodParameterUtils.getEmptyObject(field.getType(), emptyInstances, nestDepth + 1);
                        if (property == null) continue;
                        try {
                            if (!field.isAccessible()) {
                                field.setAccessible(true);
                            }
                            field.set(value, property);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                return value;
            }
            catch (Throwable e) {
                return null;
            }
        }
        return null;
    }
}

