/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.message.common.utils.kryo.factory;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import com.xforceplus.janus.message.common.utils.kryo.factory.CompatibleKryo;
import de.javakaffee.kryoserializers.ArraysAsListSerializer;
import de.javakaffee.kryoserializers.GregorianCalendarSerializer;
import de.javakaffee.kryoserializers.JdkProxySerializer;
import de.javakaffee.kryoserializers.RegexSerializer;
import de.javakaffee.kryoserializers.SynchronizedCollectionsSerializer;
import de.javakaffee.kryoserializers.URISerializer;
import de.javakaffee.kryoserializers.UUIDSerializer;
import de.javakaffee.kryoserializers.UnmodifiableCollectionsSerializer;
import java.lang.reflect.InvocationHandler;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;

public abstract class AbstractKryoFactory {
    private static final Set<Class<?>> CUSTOM_CLASSES = new LinkedHashSet();
    private static final Map<Class<?>, Serializer<?>> CUSTOM_CLASS_SERIALIZERS = new LinkedHashMap();
    private volatile boolean created = false;

    public void registerClass(Class<?> clazz) {
        Validate.validState((!this.created ? 1 : 0) != 0, (String)"Please register class before creating kryo instance!", (Object[])new Object[0]);
        CUSTOM_CLASSES.add(clazz);
    }

    public void registerClass(Class<?> clazz, Serializer<?> serializer) {
        Validate.validState((!this.created ? 1 : 0) != 0, (String)"Please register class serializer before creating kryo instance!", (Object[])new Object[0]);
        CUSTOM_CLASS_SERIALIZERS.put(clazz, serializer);
    }

    public Kryo createInstance() {
        if (!this.created) {
            this.created = true;
        }
        CompatibleKryo kryo = new CompatibleKryo();
        kryo.setRegistrationRequired(false);
        this.registerSystemClasses(kryo);
        this.registerCustomClasses(kryo);
        return kryo;
    }

    private void registerSystemClasses(Kryo kryo) {
        kryo.addDefaultSerializer(Throwable.class, (Serializer)new JavaSerializer());
        kryo.register(Collections.singletonList("").getClass(), (Serializer)new ArraysAsListSerializer());
        kryo.register(GregorianCalendar.class, (Serializer)new GregorianCalendarSerializer());
        kryo.register(InvocationHandler.class, (Serializer)new JdkProxySerializer());
        kryo.register(Pattern.class, (Serializer)new RegexSerializer());
        kryo.register(URI.class, (Serializer)new URISerializer());
        kryo.register(UUID.class, (Serializer)new UUIDSerializer());
        UnmodifiableCollectionsSerializer.registerSerializers((Kryo)kryo);
        SynchronizedCollectionsSerializer.registerSerializers((Kryo)kryo);
        kryo.register(HashMap.class);
        kryo.register(ArrayList.class);
        kryo.register(LinkedList.class);
        kryo.register(HashSet.class);
        kryo.register(TreeSet.class);
        kryo.register(Hashtable.class);
        kryo.register(Instant.class);
        kryo.register(LocalDate.class);
        kryo.register(LocalDateTime.class);
        kryo.register(ConcurrentHashMap.class);
        kryo.register(SimpleDateFormat.class);
        kryo.register(GregorianCalendar.class);
        kryo.register(Vector.class);
        kryo.register(BitSet.class);
        kryo.register(StringBuffer.class);
        kryo.register(StringBuilder.class);
        kryo.register(Object.class);
        kryo.register(Object[].class);
        kryo.register(String[].class);
        kryo.register(byte[].class);
        kryo.register(char[].class);
        kryo.register(int[].class);
        kryo.register(float[].class);
        kryo.register(double[].class);
    }

    private void registerCustomClasses(Kryo kryo) {
        CUSTOM_CLASSES.forEach(arg_0 -> ((Kryo)kryo).register(arg_0));
        CUSTOM_CLASS_SERIALIZERS.forEach((arg_0, arg_1) -> ((Kryo)kryo).register(arg_0, arg_1));
    }

    public abstract Kryo getKryo();

    public abstract void releaseKryo(Kryo var1);
}

