package com.xforceplus.janus.message.common.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Size;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 请求消息
 *
 * @author zhujie@xforceplus.com
 * @date 2021/3/3 2:53 PM
 **/
@ApiModel("请求消息")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class RequestMessage implements Serializable {

    @ApiModelProperty(value = "消息内容", required = true, notes = "格式为字符串")
    @NotEmpty
    private String content;

    @ApiModelProperty(value = "消息属性Map", required = false)
    private Map<String, String> properties;

    @ApiModelProperty(value = "发送时间戳，用来记录生产者发送消息时间点", required = false, example = "1614930380000")
    private long sentTime;

    public Map<String, String> getProperties() {
        if (MapUtils.isEmpty(properties)) {
            properties = new HashMap<>();
        }
        return properties;
    }

    public String checkProperties(List<String> checkAttrNames) {
        if (CollectionUtils.isEmpty(checkAttrNames)) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        final Map<String, String> properties = getProperties();
        for (String attrName : checkAttrNames) {
            //如果不包含则进行返回消息的拼装
            if (!properties.containsKey(attrName)) {
                result.append(attrName + " 属性必填");
            }
        }
        return result.toString();
    }
}
