package com.xforceplus.janus.message.common.dto.admin;

import com.baomidou.mybatisplus.annotation.TableName;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * <p>
 * 业务配置
 * </p>
 *
 * @author zhu jie
 * @since 2021-04-13
 */
@Data
@TableName("t_pub")
@ApiModel(value = "Pub对象", description = "业务表")
public class PubConfigDTO {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键", required = true)
    private String id;

    @ApiModelProperty(value = "MQ集群编码")
    private String mqClusterCode;

    @ApiModelProperty(value = "RocketMQ的topicName")
    private String topicName;

    @ApiModelProperty(value = "每秒允许的请求次数")
    private Long permitsPerSecond;

    @ApiModelProperty(value = "必填属性")
    private List<String> attrNames;
}
