package com.xforceplus.janus.message.common.utils;

import java.util.concurrent.*;

public class MessasageReplayThreadPoolUtils {

    private static final ThreadPoolExecutor EXECUTOR = new ThreadPoolExecutor(16, 32, 60, TimeUnit.SECONDS, new ArrayBlockingQueue<>(1024));

    public static void execute(Runnable runnable) {
        while (EXECUTOR.getQueue().size() >=1000){
            try {
                TimeUnit.SECONDS.sleep(1);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        EXECUTOR.execute(runnable);
    }

    public static <T> Future<T> submit(Callable<T> runnable) {
        return EXECUTOR.submit(runnable);
    }

}
