/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.message.common.utils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DateTimeUtils {
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final ThreadLocal<Map<String, DateFormat>> dateFormatThreadLocal = new ThreadLocal();

    public static List<String> getDays(String startTime, String endTime, String format) {
        ArrayList<String> days = new ArrayList<String>();
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        try {
            Date start = dateFormat.parse(startTime);
            Date end = dateFormat.parse(endTime);
            Calendar tempStart = Calendar.getInstance();
            tempStart.setTime(start);
            Calendar tempEnd = Calendar.getInstance();
            tempEnd.setTime(end);
            tempEnd.add(5, 1);
            while (tempStart.before(tempEnd)) {
                days.add(dateFormat.format(tempStart.getTime()));
                tempStart.add(6, 1);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return days;
    }

    public static List<String> getDays(Date start, Date end, String format) {
        ArrayList<String> days = new ArrayList<String>();
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        try {
            Calendar tempStart = Calendar.getInstance();
            tempStart.setTime(start);
            Calendar tempEnd = Calendar.getInstance();
            tempEnd.setTime(end);
            tempEnd.add(5, 1);
            while (tempStart.before(tempEnd)) {
                days.add(dateFormat.format(tempStart.getTime()));
                tempStart.add(6, 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return days;
    }

    public static Date addYears(Date date, int amount) {
        return DateTimeUtils.add(date, 1, amount);
    }

    public static Date addMonths(Date date, int amount) {
        return DateTimeUtils.add(date, 2, amount);
    }

    public static Date addDays(Date date, int amount) {
        return DateTimeUtils.add(date, 5, amount);
    }

    public static Date addSeconds(Date date, int amount) {
        return DateTimeUtils.add(date, 13, amount);
    }

    public static Date addHours(Date date, int amount) {
        return DateTimeUtils.add(date, 11, amount);
    }

    private static Date add(Date date, int calendarField, int amount) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(calendarField, amount);
        return c.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DateFormat getDateFormat(String pattern) {
        if (pattern == null || pattern.trim().length() == 0) {
            throw new IllegalArgumentException("pattern cannot be empty.");
        }
        Map<String, DateFormat> dateFormatMap = dateFormatThreadLocal.get();
        if (dateFormatMap != null && dateFormatMap.containsKey(pattern)) {
            return dateFormatMap.get(pattern);
        }
        ThreadLocal<Map<String, DateFormat>> threadLocal = dateFormatThreadLocal;
        synchronized (threadLocal) {
            if (dateFormatMap == null) {
                dateFormatMap = new HashMap<String, DateFormat>();
            }
            dateFormatMap.put(pattern, new SimpleDateFormat(pattern));
            dateFormatThreadLocal.set(dateFormatMap);
        }
        return dateFormatMap.get(pattern);
    }

    public static String format(Date date, String patten) {
        return DateTimeUtils.getDateFormat(patten).format(date);
    }

    public static String formatDate(Date date) {
        return DateTimeUtils.format(date, DATE_FORMAT);
    }

    public static String formatDateTime(Date date) {
        return DateTimeUtils.format(date, DATETIME_FORMAT);
    }

    public static Date getZeroTimeOfDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date newDate = calendar.getTime();
        return newDate;
    }

    public static Date getLastTimeOfDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        Date newDate = calendar.getTime();
        return newDate;
    }

    public static Date getFirstDateOfCurrentMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date newDate = calendar.getTime();
        return newDate;
    }

    public static Date getFirstDateOfCurrentYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date newDate = calendar.getTime();
        return newDate;
    }

    public static void main(String[] args) {
        Date now = new Date();
        System.out.println(DateTimeUtils.formatDateTime(DateTimeUtils.getFirstDateOfCurrentMonth(now)));
        System.out.println(DateTimeUtils.formatDateTime(DateTimeUtils.getFirstDateOfCurrentYear(now)));
    }
}

