/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.message.common.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class GenericBuilder<T> {
    private final Supplier<T> instantiator;
    private final List<Consumer<T>> instanceModifiers = new ArrayList<Consumer<T>>();

    protected GenericBuilder(Supplier<T> instantiator) {
        this.instantiator = instantiator;
    }

    public static final <T> GenericBuilder<T> of(Supplier<T> instantiator) {
        return new GenericBuilder<T>(instantiator);
    }

    public <U> GenericBuilder<T> withNonnull(BiConsumer<T, U> consumer, U value) {
        return value != null ? this.with(consumer, value) : this;
    }

    public <U> GenericBuilder<T> with(boolean condition, BiConsumer<T, U> consumer, U value) {
        if (condition) {
            this.with(consumer, value);
        }
        return this;
    }

    public <U> GenericBuilder<T> with(BiConsumer<T, U> consumer, U value) {
        Consumer<Object> instanceModifier = instance -> consumer.accept(instance, value);
        this.instanceModifiers.add(instanceModifier);
        return this;
    }

    public T build() {
        Object instance = this.instantiator.get();
        this.instanceModifiers.forEach(modifier -> modifier.accept(instance));
        this.instanceModifiers.clear();
        return instance;
    }
}

